% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_random_cutout}
\alias{img_random_cutout}
\title{Random cutout}
\usage{
img_random_cutout(
  images,
  mask_size,
  constant_values = 0,
  seed = NULL,
  data_format = "channels_last"
)
}
\arguments{
\item{images}{A tensor of shape (batch_size, height, width, channels) (NHWC),
(batch_size, channels, height, width)(NCHW).}

\item{mask_size}{Specifies how big the zero mask that will be generated is that
is applied to the images. The mask will be of size (mask_height x mask_width).
Note: mask_size should be divisible by 2.}

\item{constant_values}{What pixel value to fill in the images in the area that
has the cutout mask applied to it.}

\item{seed}{An integer. Used in combination with `tf$random$set_seed` to
create a reproducible sequence of tensors across multiple calls.}

\item{data_format}{A string, one of `channels_last` (default) or `channels_first`.
The ordering of the dimensions in the inputs. `channels_last` corresponds to inputs
with shape `(batch_size, ..., channels)` while `channels_first` corresponds to inputs
with shape `(batch_size, channels, ...)`.}
}
\value{
An image Tensor.
}
\description{
Apply cutout (https://arxiv.org/abs/1708.04552) to images.
}
\details{
This operation applies a (mask_height x mask_width) mask of zeros to
a random location within `img`. The pixel values filled in will be of the
value `replace`. The located where the mask will be applied is randomly
chosen uniformly over the whole images.
}
\section{Raises}{

InvalidArgumentError: if mask_size can't be divisible by 2.
}

