% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{residuals.ssm}
\alias{residuals.ssm}
\title{Residuals of fitted state space models}
\usage{
\method{residuals}{ssm}(object, method = c("exact", "cond"), ...)
}
\arguments{
\item{object}{an object of class \code{\link{ssm}}.}

\item{method}{character. Either "exact" or "conditional" residuals.}

\item{...}{additional arguments.}
}
\value{
A \code{ts} object containing the residuals of the SSM.
}
\description{
\code{residuals.ssm} generates the residuals of a fitted \code{\link{ssm}}
object.
}
\details{
These residuals are calculated by first converting the
  \code{\link{ssm}} object to a \code{\link{um}} object and then using the
  \code{\link{residuals.um}} function.
}
\examples{

# Local level model
b <- 1
C <- as.matrix(1)
ssm1 <- ssm(Nile, b, C, S = diag(c(irr = 15127.7, lvl = 1453.2)))
u <-residuals(ssm1)

}
