% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts.R
\name{sts_autoregressive_state_space_model}
\alias{sts_autoregressive_state_space_model}
\title{State space model for an autoregressive process.}
\usage{
sts_autoregressive_state_space_model(
  num_timesteps,
  coefficients,
  level_scale,
  initial_state_prior,
  observation_noise_scale = 0,
  initial_step = 0,
  validate_args = FALSE,
  name = NULL
)
}
\arguments{
\item{num_timesteps}{Scalar \code{integer} \code{tensor} number of timesteps to model
with this distribution.}

\item{coefficients}{\code{float} \code{tensor} of shape \code{tf$concat(batch_shape, list(order))}
defining  the autoregressive coefficients. The coefficients are defined
backwards in time:
\code{coefficients[0] * level[t] + coefficients[1] * level[t-1] + ... + coefficients[order-1] * level[t-order+1]}.}

\item{level_scale}{Scalar (any additional dimensions are treated as batch
dimensions) \code{float} \code{tensor} indicating the standard deviation of the
transition noise at each step.}

\item{initial_state_prior}{instance of \code{tfd_multivariate_normal} representing
the prior distribution on latent states.  Must have event shape \code{list(order)}.}

\item{observation_noise_scale}{Scalar (any additional dimensions are
treated as batch dimensions) \code{float} \code{tensor} indicating the standard
deviation of the observation noise. Default value: 0.}

\item{initial_step}{Optional scalar \code{int} \code{tensor} specifying the starting
timestep. Default value: 0.}

\item{validate_args}{\code{logical}. Whether to validate input
with asserts. If \code{validate_args} is \code{FALSE}, and the inputs are
invalid, correct behavior is not guaranteed. Default value: \code{FALSE}.}

\item{name}{name prefixed to ops created by this class. Default value: "AutoregressiveStateSpaceModel".}
}
\value{
an instance of \code{LinearGaussianStateSpaceModel}.
}
\description{
A state space model (SSM) posits a set of latent (unobserved) variables that
evolve over time with dynamics specified by a probabilistic transition model
\code{p(z[t+1] | z[t])}. At each timestep, we observe a value sampled from an
observation model conditioned on the current state, \code{p(x[t] | z[t])}. The
special case where both the transition and observation models are Gaussians
with mean specified as a linear function of the inputs, is known as a linear
Gaussian state space model and supports tractable exact probabilistic
calculations; see \code{tfd_linear_gaussian_state_space_model} for
details.
}
\details{
In an autoregressive process, the expected level at each timestep is a linear
function of previous levels, with added Gaussian noise:

\if{html}{\out{<div class="sourceCode">}}\preformatted{level[t+1] = (sum(coefficients * levels[t:t-order:-1]) + Normal(0., level_scale))
}\if{html}{\out{</div>}}

The process is characterized by a vector \code{coefficients} whose size determines
the order of the process (how many previous values it looks at), and by
\code{level_scale}, the standard deviation of the noise added at each step.
This is formulated as a state space model by letting the latent state encode
the most recent values; see 'Mathematical Details' below.

The parameters \code{level_scale} and \code{observation_noise_scale} are each (a batch
of) scalars, and \code{coefficients} is a (batch) vector of size \code{list(order)}. The
batch shape of this \code{Distribution} is the broadcast batch
shape of these parameters and of the \code{initial_state_prior}.

Mathematical Details

The autoregressive model implements a
\code{tfd_linear_gaussian_state_space_model} with \code{latent_size = order}
and \code{observation_size = 1}. The latent state vector encodes the recent history
of the process, with the current value in the topmost dimension. At each
timestep, the transition sums the previous values to produce the new expected
value, shifts all other values down by a dimension, and adds noise to the
current value. This is formally encoded by the transition model:

\if{html}{\out{<div class="sourceCode">}}\preformatted{transition_matrix = [ coefs[0], coefs[1], ..., coefs[order]
                      1.,       0 ,       ..., 0.
                      0.,       1.,       ..., 0.
                      ...
                      0.,       0.,  ...,  1., 0.         ]
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{transition_noise ~ N(loc=0., scale=diag([level_scale, 0., 0., ..., 0.]))
}\if{html}{\out{</div>}}

The observation model simply extracts the current (topmost) value, and
optionally adds independent noise at each step:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observation_matrix = [[1., 0., ..., 0.]]
observation_noise ~ N(loc=0, scale=observation_noise_scale)
}\if{html}{\out{</div>}}

Models with \code{observation_noise_scale = 0} are AR processes in the formal
sense. Setting \code{observation_noise_scale} to a nonzero value corresponds to a
latent AR process observed under an iid noise model.
}
\seealso{
Other sts: 
\code{\link{sts_additive_state_space_model}()},
\code{\link{sts_autoregressive}()},
\code{\link{sts_constrained_seasonal_state_space_model}()},
\code{\link{sts_dynamic_linear_regression}()},
\code{\link{sts_dynamic_linear_regression_state_space_model}()},
\code{\link{sts_linear_regression}()},
\code{\link{sts_local_level}()},
\code{\link{sts_local_level_state_space_model}()},
\code{\link{sts_local_linear_trend}()},
\code{\link{sts_local_linear_trend_state_space_model}()},
\code{\link{sts_seasonal}()},
\code{\link{sts_seasonal_state_space_model}()},
\code{\link{sts_semi_local_linear_trend}()},
\code{\link{sts_semi_local_linear_trend_state_space_model}()},
\code{\link{sts_smooth_seasonal}()},
\code{\link{sts_smooth_seasonal_state_space_model}()},
\code{\link{sts_sparse_linear_regression}()},
\code{\link{sts_sum}()}
}
\concept{sts}
