% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoulders.R
\name{shoulders}
\alias{shoulders}
\title{Find Out Who Maintains the Packages you Use}
\usage{
shoulders(where = c("session", "library", "package"), package,
  include_dependencies = TRUE)
}
\arguments{
\item{where}{either look in the current loaded "session", your whole "library" or for a specific "package"}

\item{package}{if \code{where} is "package" then this must be a character vector of positive length}

\item{include_dependencies}{if \code{where} is "package" then use this to include all dependencies of the package.
Otherwise it will just return the maintainer.}
}
\value{
A data.frame showing all packages you depend on with these three columns:
        \itemize{
        \item{\code{maintainer}}{ The maintainer as in the DESCRIPTION file}
        \item{\code{no_packages}}{ The number of packages of that maintainer}
        \item{\code{packages}}{ A comma separated list of those packages}
        }
}
\description{
This function helps to identify what packages you depend on. It finds the maintainers and the
number of packages they maintain.
}
\details{
Note, if you do a package lookup you connect to a CRAN mirror.
}
\examples{
\dontrun{
# identifies the packages currently loaded in your session
shoulders() # equal to shoulders("session")

# shows all maintainers of your package library
shoulders("library")

# find out about a specific package
# by default it lists all dependencies of that package as well
shoulders("package", "utils", include_dependencies = FALSE)
shoulders("package", "utils")
}
}
