% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{simple_colors}
\alias{simple_colors}
\title{Simple random color selection}
\usage{
simple_colors(n = 10, palette = NULL)
}
\arguments{
\item{n}{The number of colors to return. Default is \code{10}.}

\item{palette}{The name of the palette to use.
If \code{NULL} (default), colors will be selected from ChineseColors.
Otherwise, colors will be selected from the specified palette.
Available palette names can be queried with \link{show_palettes}.}
}
\value{
A character vector of hexadecimal color codes.
}
\description{
Randomly select a specified number of colors from ChineseColors or other palettes.
}
\examples{
simple_colors()

show_palettes(simple_colors(n = 5))

# Get colors from a specific palette
simple_colors(n = 10, palette = "Paired")
simple_colors(n = 10, palette = "ChineseBlue")
simple_colors(n = 10, palette = "Spectral")
}
