% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-grants.R
\name{tsg_all_grants}
\alias{tsg_all_grants}
\title{All grants}
\usage{
tsg_all_grants(verbose = TRUE, timeout = 30, retries = 0, correct_names = TRUE)
}
\arguments{
\item{verbose}{If \code{TRUE}, prints console messages on data retrieval progress.
Defaults to \code{TRUE}.}

\item{timeout}{The maximum request time, in seconds. If data is not returned
in this time, a value of \code{NA} is returned for that dataset.
Defaults to 30 seconds.}

\item{retries}{The number of retries to make if a request is not successful.
Defaults to 0.}

\item{correct_names}{If \code{TRUE}, corrects known mistakes in column names,
such as spelling mistakes. Defaults to \code{TRUE}.}
}
\value{
A list of tibbles with grant data.
}
\description{
Returns a list of data frames with details of all grants from funders
returned by \code{\link[=tsg_available]{tsg_available()}}.
}
\details{
Due to the structure of the 360 Giving data, the package will make
multiple attempts to request data. This can cause issues with servers
automatically blocking requests. You can use \code{\link[=tsg_missing]{tsg_missing()}} to identify
missing sets of grant data.
}
\examples{
\dontrun{
all_grants <- tsg_all_grants()
}

}
