% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_wir.R
\name{tic_wir}
\alias{tic_wir}
\title{Return wash in rate from time-intensity data}
\usage{
tic_wir(data, timevar, intensityvar, loess.span = 0.1, plotresult = FALSE, ...)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{loess.span}{A number between 0 and 1, with larger values resulting in a smoother curve.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}

\item{...}{Additional arguments to be passed into the loess() function.}
}
\value{
The wash in rate. Depending on the plotresult argument can also
return a plot of the smoothed curve with the calculated slope shown.
}
\description{
This function returns the wash in rate from time-intensity curve data. Raw data
is smoothed using a loess smoother. Wash in rate is calculated as the maximum upward
slope of the loess curve before peak intensity is reached. It is recommended that
plotresult is set to TRUE in the first instance to visually confirm the analysis.
}
\examples{

# Example usage: Please see package vignettes on CRAN

}
