% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-tunable-params.R
\name{extract_tunable_params}
\alias{extract_tunable_params}
\title{Extract Tunable Parameters from Model Specifications}
\usage{
extract_tunable_params(.model_tbl)
}
\arguments{
\item{.model_tbl}{A model table with a class of \code{tidyaml_mod_spec_tbl}.}
}
\value{
A list of tibbles, each containing the tunable parameters for a model.
}
\description{
Extract a list of tunable parameters from the \code{.model_spec} column
of a \code{tidyaml_mod_spec_tbl}.
}
\details{
This function iterates over the \code{.model_spec} column of a model table
and extracts tunable parameters for each model using \code{tunable()}. The result
is a list that can be further processed into a tibble if needed.
}
\examples{
library(dplyr)
mods <- fast_regression_parsnip_spec_tbl(
  .parsnip_fns = "linear_reg",
  .parsnip_eng = c("lm","glmnet")
  )
extract_tunable_params(mods)

}
\seealso{
Other Extractor: 
\code{\link{extract_model_spec}()},
\code{\link{extract_regression_residuals}()},
\code{\link{extract_wflw}()},
\code{\link{extract_wflw_fit}()},
\code{\link{extract_wflw_pred}()},
\code{\link{get_model}()}
}
\concept{Extractor}
