% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_countries_by_region}
\alias{get_countries_by_region}
\title{get_countries_by_region}
\usage{
get_countries_by_region(country_region_value, geometry = FALSE)
}
\arguments{
\item{country_region_value}{A character string representing the region, subregion, or continent. The input is case-insensitive.}

\item{geometry}{Logical. If \code{TRUE}, includes spatial geometry data for each country (boundaries).
Defaults to \code{FALSE}. When \code{TRUE}, an additional column for geographic boundaries is included.}
}
\value{
A data frame with information on countries within the specified region, subregion, or continent.
If \code{geometry = TRUE}, the result includes a geometry column with boundary data.
If no match is found, a message lists all available regions, subregions, and continents.
}
\description{
This function retrieves a list of countries based on a specified region, subregion, or continent.
The function is case-insensitive and orders the countries alphabetically by their common names.
If the input does not match any region, subregion, or continent, the function provides a list of all available regions, subregions, and continents.
}
\note{
This function returns relevant information on countries in a specified region. When \code{geometry = TRUE}, it returns an \code{sf} object, including spatial data.
}
\examples{
\donttest{
# Example usage: Get a list of countries in Africa
africa_countries <- get_countries_by_region("Africa")
print(africa_countries)

# Example usage: Get countries in a specific continent with geometry included
western_europe_countries <- get_countries_by_region("Western Europe", geometry = TRUE)
print(western_europe_countries)

# Example usage: Get a list of countries in the continent of Asia
asia_countries <- get_countries_by_region("Asia")
print(asia_countries)
}

}
