% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silinfo.R
\name{nk}
\alias{nk}
\title{nk}
\usage{
nk(data, k)
}
\arguments{
\item{data}{input data (a matrix or data frame)}

\item{k}{a vector of candidate number of clusters}
}
\value{
a \code{silinfo} object, which contains 'data' (original data), 'silinfo' (silhouette scores), and k (the input k vector)
}
\description{
Choose best K (number of clusters)
}
\details{
This function calculate the silhouette scores of each K (number of clusters).
The output object can be used to choose the best K (via \code{summary()} or \code{autoplot()} methods)
}
\examples{
x <- nk(iris[,-5], 2:8)
summary(x)
# to visualize the average silhouete score (y axis) with k (x axis)
autoplot(x)
# to visualize a PCA plot color by the choosing k
autoplot(x, k=3)
}
\author{
Guangchuang Yu
}
