% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{dct}
\alias{dct}
\alias{dct.numeric}
\alias{dct.matrix}
\title{Discrete Cosine Transform}
\usage{
dct(x)

\method{dct}{numeric}(x)

\method{dct}{matrix}(x)
}
\arguments{
\item{x}{A vector or matrix to which the discrete cosine transform is applied}
}
\value{
Returned value depends on \code{x}.

When passed a numeric vector, returns a numeric
vector the same size as \code{x} with the DCT Coefficients.

When passed a matrix, returns a matrix
the same size as \code{x} with the DCT Coefficients.
}
\description{
Discrete Cosine Transform
}
\details{
The DCT definitions here are based on the python \code{scipy.fft.dct} definitions.
Specifically this use:

\if{html}{\out{<div class="sourceCode python">}}\preformatted{# python code
scipy.fft.dct(x, norm = "forward", orthogonalize = True)
}\if{html}{\out{</div>}}

\deqn{
y_k = \frac{1}{zN} \sum_{j=0}^{N-1}x_j\cos\left(\frac{\pi k(2j+1)}{2N}\right)
}

\deqn{
z = \begin{cases}
   \sqrt{2}& \text{for }k=0\\
   1 & \text{for }k>0
 \end{cases}
}

For the Inverse Discrete Cosine Transform, see \link{idct}.
}
\examples{
x <- seq(0, 1, length = 10)
y <- 5 + x + (2 * (x^2)) + (-2 * (x^4))

dct_coefs <- dct(y)

}
\keyword{internal}
