% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_cellsize.R
\name{grid_cellsize}
\alias{grid_cellsize}
\title{Get default grid cellsize for a given dataset}
\usage{
grid_cellsize(data, n = c(10, 10))
}
\arguments{
\item{data}{a \link[sf:sf]{sf::sf} dataset used to size the grid}

\item{n}{the number of cells in the grid, defaults to c(10,10), which is also
the default for \code{\link[sf:st_make_grid]{sf::st_make_grid()}}}
}
\value{
the cell size
}
\description{
This function facilitates using \link[spatialsample:spatial_block_cv]{spatialsample::spatial_block_cv} multiple
times in an analysis. \link[spatialsample:spatial_block_cv]{spatialsample::spatial_block_cv} creates a grid based
on the object in \code{data}. However, if spatial blocks are generated multiple
times in an analysis (e.g. for a \code{\link[=spatial_initial_split]{spatial_initial_split()}}, and then
subsequently for cross-validation on the training dataset), it might be
desirable to keep the same grid). By applying this function to the largest
dataset, usually the full dataset before \code{\link[=spatial_initial_split]{spatial_initial_split()}}. The
resulting cellsize can be used as an option in
\link[spatialsample:spatial_block_cv]{spatialsample::spatial_block_cv}.
}
