% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_blc_rollingBall.R
\name{spec_blc_rollingBall}
\alias{spec_blc_rollingBall}
\title{Apply Rolling Ball Baseline Correction to Spectral Data}
\usage{
spec_blc_rollingBall(
  .data,
  wn_col = NULL,
  wn_min = NULL,
  wn_max = NULL,
  wm,
  ws = 0,
  is_abs = TRUE
)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}

\item{wn_min}{A numeric value specifying the minimum wavelength to consider for the baseline correction.}

\item{wn_max}{A numeric value specifying the maximum wavelength to consider for the baseline correction.}

\item{wm}{A numeric value for the window size of the rolling ball algorithm.}

\item{ws}{A numeric value for the smoothing factor of the rolling ball algorithm.}

\item{is_abs}{A logical value indicating whether the data is already in absorbance. If `TRUE`, absorbance is used directly; if `FALSE`, the data is converted to absorbance before applying the baseline correction.}
}
\value{
A `tibble` with the baseline-corrected spectral data, containing the wavelength column and the corrected numeric columns.
}
\description{
This function applies a rolling ball baseline correction to spectral data within a specified wavelength range.
It allows for correction of either absorbance or transmittance data.
}
\references{
Baseline estimation performed using a custom rolling ball implementation.
}
