% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_norm_minmax.R
\name{spec_norm_minmax}
\alias{spec_norm_minmax}
\title{Normalize Spectral Data to a Specified Range}
\usage{
spec_norm_minmax(.data, wn_col = NULL, min = 0, max = 1)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}

\item{min}{A numeric value specifying the minimum value of the desired range. Default is 0.}

\item{max}{A numeric value specifying the maximum value of the desired range. Default is 1.}
}
\value{
A `tibble` with the normalized spectral data, containing the wavelength column and the normalized numeric columns.
}
\description{
This function normalizes the numeric spectral data in each column to a specified range [min, max], preserving the wavelength column.
}
