% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_pca_screeplot.R
\name{spec_pca_screeplot}
\alias{spec_pca_screeplot}
\title{Scree plot for PCA results}
\usage{
spec_pca_screeplot(
  pca,
  n = 10,
  show_labels = TRUE,
  show_cumulative = TRUE,
  bar_color = "steelblue",
  line_color = "darkred",
  show_kaiser = FALSE,
  title = "Scree Plot",
  subtitle = NULL,
  accuracy = 1
)
}
\arguments{
\item{pca}{A PCA object returned by [prcomp()].}

\item{n}{Number of components to display. Defaults to 10.}

\item{show_labels}{Logical. Show percentage labels on bars? Default is TRUE.}

\item{show_cumulative}{Logical. Show cumulative variance line? Default is TRUE.}

\item{bar_color}{Fill color for bars. Default is "steelblue".}

\item{line_color}{Color of the cumulative line and points. Default is "darkred".}

\item{show_kaiser}{Logical. Show Kaiser criterion line? Default is FALSE.}

\item{title}{Plot title. Default is "Scree Plot".}

\item{subtitle}{Optional plot subtitle.}

\item{accuracy}{Number of decimal places for variance percentages. Default is 1.}
}
\value{
A ggplot2 scree plot object.
}
\description{
Creates a customizable scree plot based on a `prcomp` object showing variance explained by each component.
}
\examples{
pca <- prcomp(USArrests, scale. = TRUE)
spec_pca_screeplot(pca, n = 4)
spec_pca_screeplot(pca, show_kaiser = TRUE, bar_color = "darkblue")
}
