% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_smooth_sga.R
\name{spec_smooth_sga}
\alias{spec_smooth_sga}
\title{Apply Savitzky-Golay Smoothing to Spectral Data}
\usage{
spec_smooth_sga(.data, wn_col = NULL, window = 15, forder = 4, degree = 0)
}
\arguments{
\item{.data}{A `data.frame` or `tibble` containing spectral data.}

\item{wn_col}{A character string specifying the column name for the wavelength data. Default is `"Wn"`.}

\item{window}{A numeric value specifying the window size for the Savitzky-Golay smoothing. Default is 15.}

\item{forder}{A numeric value specifying the polynomial order for smoothing. Default is 4.}

\item{degree}{A numeric value specifying the degree of differentiation. Default is 0 (no differentiation).}
}
\value{
A `tibble` with the smoothed spectral data, containing the wavelength column and the smoothed numeric columns.
}
\description{
This function applies Savitzky-Golay smoothing to numeric spectral data using a specified window size, polynomial order, and differentiation degree, while preserving the wavelength column.
}
