% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_models.R
\name{construct_models}
\alias{construct_models}
\title{Construct a list of models for synthesis}
\usage{
construct_models(
  roadmap,
  default_regression_model = NULL,
  default_classification_model = NULL,
  custom_models = NULL
)
}
\arguments{
\item{roadmap}{A roadmap object}

\item{default_regression_model}{A \code{parsnip} model object used for
regression in numeric outcome variables}

\item{default_classification_model}{A \code{parsnip} model object used for
classification in categorical outcome variables}

\item{custom_models}{A formatted list with \code{parsnip} model objects explicitly
paired with every variable in the \code{visit_sequence}}
}
\value{
A named list of models
}
\description{
Construct a list of models for synthesis
}
\examples{

# construct_models() can create a sequence of models using a fully-default 
# approach, a hybrid approach, or a fully-customized approach. All approaches
# require a roadmap and model objects. 

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

rpart_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

rpart_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

lm_mod <- parsnip::linear_reg() |> 
  parsnip::set_engine("lm") |>
  parsnip::set_mode(mode = "regression")

# Fully-default approach

construct_models(
  roadmap = rm, 
  default_regression_model = lm_mod, 
  default_classification_model = rpart_mod_class
)

# Hybrid approach

construct_models(
  roadmap = rm, 
  default_regression_model = lm_mod,
  default_classification_model = rpart_mod_class,
  custom_models = list(
    list(vars = "age", model = lm_mod)
  )
)

# Fully-customized approach

construct_models(
  roadmap = rm, 
  custom_models = list(
    list(vars = c("hcovany", "empstat", "classwkr"), model = rpart_mod_class),
    list(vars = c("age", "famsize", "transit_time", "inctot"), model = rpart_mod_reg)
  )
)

}
