% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoSampleKaplanMeier.R
\name{TwoSampleKaplanMeier}
\alias{TwoSampleKaplanMeier}
\title{Risk difference and risk ratio using the Kaplan-Meier method}
\usage{
TwoSampleKaplanMeier(
  time,
  status,
  group,
  t,
  SR.H0 = 1,
  RR.H0 = 1,
  Diff.H0 = 0,
  level = 0.95,
  contr = list(tol = 1e-05, algo = 2, k = 3, Trace = FALSE, method = "both")
)
}
\arguments{
\item{time}{vector of times (possibly censored)}

\item{status}{vector of usual survival status indicators (0 for censored observations, 1 otherwise)}

\item{group}{vector of binary group indicator. The reference group should be coded 0, the other 1.}

\item{t}{the time point of interest (e.g. 1 to compute 1-year risk ratio)}

\item{SR.H0}{the survival ratio under the null hypothesis, to compute a p-value. Default is 1.}

\item{RR.H0}{the risk ratio under the null hypothesis, to compute a p-value. Default is 1.}

\item{Diff.H0}{the risk difference under the null hypothesis, to compute a p-value. Default is 0.}

\item{level}{confidence level for the confidence intervals. Default is 0.95.}

\item{contr}{list of control parameters. tol=tolerance for numerical computation, default is 1e-5. method="EL", "Wald" or "both"  indicates wether 95\% CI and the p-value should be computed based on Empirical Likelihood inference, Wald-type inference or both. algo=2 is currently the only option that is implemented.}
}
\value{
an object of class 'TwoSampleKaplanMeier'
}
\description{
Computes a risk difference, risk ratio or survival ratio with right-censored data, together with a confidence interval and
a p-value (to test for a difference between two groups). Pointwise estimates are computed via the Kaplan-Meier estimator. Computation of confidence intervals
and p-values are based on either Empirical Likelihood (EL) inference or Wald-type inference. Both are non-parametric approaches, which are asymptotically equivalent.
See Thomas & Grunkemeier (1975) for details about the Empirical Likelihood method. For the Wald-type approach, the asymptotic normal approximation is used on
the log scale for the risk ratio or survival ratio. No transformation is used for the risk or survival difference.
}
\examples{
# This example reproduces some results presented in Table 4 of Thomas and Grunkemeier (1975)
Res2SKM95 <- TwoSampleKaplanMeier(time=Freireich$time,
                                  status=Freireich$status,
                                  group=Freireich$group,
                                  t=10)
Res2SKM95


}
\references{
Thomas & Grunkemeier (1975). Confidence interval estimation of survival probabilities for censored data. Journal of the American Statistical Association, 70(352), 865-871.
}
\author{
Paul Blanche
}
