% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{taylor_30_min_df_ts}
\alias{taylor_30_min_df_ts}
\title{Half-Hourly Electricity Demand}
\format{
A `ts` object with 4032 observations:
\describe{
  \item{time}{Half-hourly time series from 1 to 13.}
  \item{value}{Electricity demand measured in half-hour intervals.}
}
}
\source{
Taylor, J.W. (2003). Short-term electricity demand forecasting using double seasonal exponential smoothing.
Journal of the Operational Research Society, 54(8), 799-805.
}
\usage{
data(taylor_30_min_df_ts)
}
\description{
The dataset name has been changed to 'taylor_30_min_df_ts' to avoid confusion with other datasets
in the R ecosystem from which data have been sourced. The suffix 'df_ts' indicates that this dataset
is a time series object formatted as a data frame. This naming convention helps distinguish this dataset
as part of the 'timeseriesdatasets' package and assists users in identifying its specific characteristics.
The original content of the dataset has not been modified in any way.
}
\details{
This dataset contains half-hourly data on electricity demand over a period. The data is organized
in a time series format with observations at 30-minute intervals.
}
\keyword{datasets}
