% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{db_ts_assign_dataset}
\alias{db_ts_assign_dataset}
\title{Assign Time Series Identifiers to a Dataset}
\usage{
db_ts_assign_dataset(con, ts_keys, set_name, schema = "timeseries")
}
\arguments{
\item{con}{RPostgres connection object.}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{set_name}{\strong{character} name of a dataset.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}
}
\value{
list A status list
}
\description{
`db_ts_assign_dataset` returns a list with status information.
status `"ok"` means all went well.
status `"warning"` means some keys are not in the catalog. The vector of
those keys is in the `offending_keys` field.
}
\details{
Trying to assign keys to a non-existent dataset is an error.
}
\examples{

\dontrun{

db_dataset_create(
  con = connection,
  set_name = "zrh_airport_data",
  set_description = "Zurich airport arrivals and departures ",
  schema = "schema"
)

db_ts_assign_dataset(
  con = connection,
  ts_keys = c(
    "ch.zrh_airport.departure.total",
    "ch.zrh_airport.arrival.total"
  ),
  set_name = "zrh_airport_data",
  schema = "schema"
)
}
}
\seealso{
Other datasets functions: 
\code{\link{db_dataset_create}()},
\code{\link{db_dataset_delete}()},
\code{\link{db_dataset_get_keys}()},
\code{\link{db_dataset_get_last_update}()},
\code{\link{db_dataset_list}()},
\code{\link{db_dataset_trim_history}()},
\code{\link{db_dataset_update_metadata}()},
\code{\link{db_ts_get_dataset}()}
}
\concept{datasets functions}
