% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_docs.R
\name{param_defs}
\alias{param_defs}
\title{Common parameters}
\arguments{
\item{con}{RPostgres connection object.}

\item{schema}{\strong{character} name of the database schema. Defaults to 'timeseries'}

\item{ts_keys}{\strong{character} vector of time series identifiers.}

\item{dataset}{\strong{character} name of the dataset. Datasets are group of time series.}

\item{datasets}{\strong{character} vector of the datasets. Dataset is a group of time series.}

\item{valid_on}{\strong{character} representation of a date in the form of 'YYYY-MM-DD'. valid_on selects the
version of a time series that is valid at the specified time.}

\item{valid_from}{character representation of a date in the form of 'YYYY-MM-DD'. valid_from starts a new version}

\item{code}{expression Code to be evaluated after populating the temporary table on the database
of a time series that is valid from the specified date.}

\item{collection_name}{\strong{character} name of a collection to read. Collection are bookmark lists that contain time series keys.}

\item{access_level}{\strong{character} describing the access level of the time series or dataset.}

\item{set_name}{\strong{character} name of a dataset.}

\item{regex}{\strong{boolean} indicating if ts_keys should be interpreted as a regular expression pattern. Defaults to FALSE.}

\item{locale}{\strong{character} indicating the language of the meta information to be store. We recommend to use ISO country codes to represent languages. Defaults to NULL. When local is set to NULL, metadata are stored without localization. Note that, when localizing meta information by assigning a language, multiple meta information objects can be stored for a single time series.}

\item{respect_release_date}{\strong{boolean} indicating if it should the release embargo of a time series be respected. Defaults to FALSE. This option makes sense when the function is used in an API. In that sense, users do not have direct access to this function and therefore cannot simply switch parameters.}

\item{chunksize}{set a limit of the number of time series requested in the function.}

\item{collection_owner}{\strong{character} username that is the owner of a collection.}

\item{user}{character name of the database user. Defaults to the user of the R session.
this is often the user for the database, too so you do not have to specify
your username explicitly if that is the case.}
}
\description{
Common parameters
}
