% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{get_category_playlists}
\alias{get_category_playlists}
\title{Get a list of Spotify playlists tagged with a particular category.}
\usage{
get_category_playlists(
  category_id,
  market = NULL,
  limit = 20,
  offset = 0,
  authorization = get_spotify_access_token(),
  include_meta_info = FALSE
)
}
\arguments{
\item{category_id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the category.}

\item{market}{Optional. A country: an \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code}.}

\item{limit}{Optional. The maximum number of items to return. Default: 20. Minimum: 1. Maximum: 50.}

\item{offset}{Optional. The index of the first item to return. Default: 0 (the first object). Use with \code{limit} to get the next set of items.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing category playlists. See \url{https://developer.spotify.com/documentation/web-api/reference/users-profile/get-current-users-profile/} for more information.
}
\description{
Get a list of Spotify playlists tagged with a particular category.
}
\examples{
\dontrun{
## Get Brazilian party playlists
get_category_playlists('party', country = 'BR')
}
}
