% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isosim.R
\name{isotitesim}
\alias{isotitesim}
\alias{titeIR}
\title{Simulate TITE-IR designs}
\usage{
isotitesim(PI, target, n, nsim, obswin = 1, rate = 1, safety = 0.05,
  accrual = "poisson", restrict = TRUE)
}
\arguments{
\item{PI}{A vector of true toxicity probabilities at each dose}

\item{target}{Target DLT rate}

\item{n}{Sample size of the trial}

\item{nsim}{Number of trial replicates}

\item{obswin}{The observation window with respect to which the MTD is defined}

\item{rate}{Patient arrival rate: expected number of arrivals per observation window}

\item{safety}{The safety factor to prevent overly aggressive escalation}

\item{accrual}{Specify the accrual distribution. Can be either \code{"poisson"} or \code{"fixed"}. Partial strings are also acceptable.}

\item{restrict}{If \code{TRUE}, do not allow escalation immediately after a toxic outcome (require coherent escalation)}
}
\value{
Object of type \code{isotite} which provides results from TITE-IR simulations
}
\description{
Simulates trials based on the TITE-IR design.
}
\examples{
isotitesim(PI = c(0.05, 0.10, 0.20, 0.30, 0.50, 0.70),
 target = 1/3, n = 24, nsim = 10, obswin = 6, rate = 12)
}
\seealso{
\code{\link{isotitedose}} for dose recommendation
}
