% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tkRplot}
\alias{tkRplot}
\alias{tkRreplot}
\alias{.tkRreplot}
\title{Tk Rplot With Resizing}
\usage{
tkRplot(W, fun, width = 490, height = 490, ...)
tkRreplot(W, fun, width, height,  ...)
.tkRreplot(W)
}
\arguments{
\item{W}{Tk toplevel window}

\item{fun}{function to produce the plot}

\item{width}{image width}

\item{height}{image height}

\item{...}{additional arguments}
}
\description{
Displays a plot in a Tk toplevel window.
}
\examples{
\dontshow{
 if (.isTclImgOk()){
tkbb <- tclVar(1)
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
bb <- .tcl2num(tkbb)
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

     s <-
       tkscale(
       tt,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = FALSE,
       resolution = 0.05,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       expand = FALSE,
       before = tt$env$canvas,
       fill = "both")

       Sys.sleep(1)
       tkdestroy(tt)
       }
}
\dontrun{
#Example 1 without using tkReplot function (tkRplotR version > 0.1.6)
tk_b <- tclVar(1)
tk_x <- tclVar(10)
tk_main <- tclVar('...')

tt0 <- tktoplevel()
tt0 <- tkRplot(tt0, function(...) {
# get values of tclvariables
  x <- .tcl2num(tk_x)
  x <- 1:x
  b <- .tcl2num(tk_b)
  main <- .tcl2String(tk_main)

  plot(
    x,
    x ^ b ,
    col = "#0000ff50",
    xlab = "x",
    ylab = expression(x^b),
    type = "l",
    axes = FALSE,
    lwd = 4)
  title(main = main)
  points(x,
         x ^ b,
         col = "#ff000050",
         pch = 19,
         cex = 2)
  axis(1)
  axis(2)
  box()
})

s01 <- tkscale(
  tt0,
  #command = function(...) .tkRreplot(tt0),
  from = 10,
  to = 60,
  label = 'x',
  variable = tk_x,
  showvalue = TRUE,
  resolution = 1,
  repeatdelay = 200,
  repeatinterval = 100,
  orient = "hor"
)

s02 <- tkscale(
  tt0,
  #command = function(...) .tkRreplot(tt0),
  from = 0.05,
  to = 2.00,
  label = 'b',
  variable = tk_b,
  showvalue = TRUE,
  resolution = 0.01,
  repeatdelay = 200,
  repeatinterval = 100,
  orient = "ver"
)


e01 <- tkentry(tt0,
              textvariable = tk_main,
              validate = 'all', validatecommand="")
tkpack(s02,
       side = "left",
       expand = FALSE,
       #'anchor = "c",
       before = tt0$env$canvas,
       fill = "both")

tkpack(s01,
       side = "bottom",
       expand = FALSE,
       #'anchor = "c",
       before = tt0$env$canvas,
       fill = "both")

tkpack(e01,
       side = "top",
       expand = FALSE,
       #'anchor = "c",
       before = tt0$env$canvas,
       fill = "both")


#Example 2 using tkReplot function (tkRplotR version < 0.1.7)
bb <- 1
tkbb <- tclVar(1)
tt <- tktoplevel()
f <- function(...) {
 b <- as.numeric(tclvalue(tkbb))
   if (b != bb) {
       bb <<- b
           tkRreplot(tt)
             }
     }

tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })

  s <- tkscale(
       tt,
       command = f,
       from = 0.05,
       to = 2.00,
       variable = tkbb,
       showvalue = TRUE,
       resolution = 0.01,
       repeatdelay = 50,
       repeatinterval = 100,
       orient = "horiz"
       )

       tkpack(s,
       side = "bottom",
       expand = FALSE,
       before = tt$env$canvas,
       fill = "both")

}
}
