% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCorpus.R
\name{readCorpus}
\alias{readCorpus}
\title{Create kRp.corpus objects from text files or data frames}
\usage{
readCorpus(
  dir,
  hierarchy = list(),
  lang = "kRp.env",
  tagger = "kRp.env",
  encoding = "",
  pattern = NULL,
  recursive = FALSE,
  ignore.case = FALSE,
  mode = "text",
  format = "file",
  mc.cores = getOption("mc.cores", 1L),
  id = "",
  ...
)
}
\arguments{
\item{dir}{Either a file path to the root directory of the text corpus,
      or a TIF compliant data frame.
If a directory path (character string),
      texts can be recursively ordered into subfolders named
exactly as defined by \code{hierarchy}. If \code{hierarchy} is an empty list,
      all text files located in
\code{dir} are parsed without a hierachical structure. If a data frame,
      also set \code{format="obj"}
and provide hierarchy levels as additional columns,
      as described in the Data frames section.}

\item{hierarchy}{A named list of named character vectors describing the directory hierarchy level by level.
If \code{TRUE} instead, the hierarchy structure is taken directly from the directory tree.
See section Hierarchy for details.}

\item{lang}{A character string naming the language of the analyzed corpus.
See \code{\link[koRpus:kRp.POS.tags]{kRp.POS.tags}} for all supported languages.
If set to \code{"kRp.env"} this is got from \code{\link[koRpus:get.kRp.env]{get.kRp.env}}.
This information will also be passed to the \code{readerControl} list of the \code{VCorpus} call.}

\item{tagger}{A character string pointing to the tokenizer/tagger command you want to use for basic text analysis.
Defaults to \code{tagger="kRp.env"} to get the settings by \code{\link[koRpus:get.kRp.env]{get.kRp.env}}.
Set to \code{"tokenize"} to use \code{\link[koRpus:tokenize]{tokenize}}.}

\item{encoding}{Character string describing the current encoding.
See \code{\link[tm:DirSource]{DirSource}} for details, omitted if \code{format="obj"}.}

\item{pattern}{A regular expression for file matching.
See \code{\link[tm:DirSource]{DirSource}} for details, omitted if \code{format="obj"}.}

\item{recursive}{Logical, indicates whether directories should be read recursively.
See \code{\link[tm:DirSource]{DirSource}} for details, omitted if \code{format="obj"}.}

\item{ignore.case}{Logical, indicates whether \code{pattern} is matched case sensitive.
See \code{\link[tm:DirSource]{DirSource}} for details, omitted if \code{format="obj"}.}

\item{mode}{Character string defining the reading mode.
See \code{\link[tm:DirSource]{DirSource}} for details, omitted if \code{format="obj"}.}

\item{format}{Either "file" or "obj",
      depending on whether you want to scan files or analyze the text in a given object,
like a character vector. If the latter and \code{\link[koRpus:treetag]{treetag}} is used as the \code{tagger},
texts will be written to temporary files for the process (see \code{dir}).}

\item{mc.cores}{The number of cores to use for parallelization,
      see \code{\link[parallel:mclapply]{mclapply}}.
This value is passed through to simpleCorpus.}

\item{id}{A character string describing the main subject/purpose of the text corpus.}

\item{...}{Additional options which are passed through to the defined \code{tagger}.}
}
\value{
An object of class \code{\link[tm.plugin.koRpus:kRp.corpus-class]{kRp.corpus}}.
}
\description{
You can either read a corpus from text files (one file per text,
      also see the Hierarchy section below)
or from TIF compliant data frames (see the Data frames section below).
}
\section{Hierarchy}{

To import a hierarchically structured text corpus you must categorize all texts in a directory
structure that resembles the hierarchy. If for example you would like to import a corpus on two
different topics and two differnt sources,
      your hierarchy has two nested levels (topic and source).
The root directory \code{dir} would then need to have two subdirectories (one for each topic)
which in turn must have two subdirectories (one for each source),
      and the actual text files
are found in those.

To use this hierarchical structure in \code{readCorpus},
      the \code{hierarchy} argument is used.
It is a named list,
      where each list item represents one hierachical level (here again topic and source),
and its value is a named character vector describing the actual topics and sources to be used. It is
important to understand how these character vectors are treated: The names of elements must exactly match
the corresponding subdirectroy name,
      whereas the value is a free text description. The names of the
list items however describe the hierachical level and are not matched with directory names.
}

\section{Data frames}{

In order to import a corpus from a data frame,
      the object must be in Text Interchange Format (TIF)
as described by [1]. As a minimum, the data frame must have two character columns,
      \code{doc_id}
and \code{text}.

You can provide additional information on hierarchical categories by using further
columns,
      where the column name must match the category name (hierachical level). The order of those
columns in the data frame is not important,
      as you must still fully define the hierarchical structure
using the \code{hierarchy} argument. All columns you omit are ignored,
      but the values used in
the \code{hierarchy} list and the respective columns must match,
      as rows with unmatched category levels
will also be ignored.

Note that the special column names \code{path} and \code{file} will also be imported automatically.
}

\examples{
# use readCorpus() to create an object of class kRp.corpus
# code is only run when the english language package can be loaded
if(require("koRpus.lang.en", quietly = TRUE)){
  # "flat" corpus, parse all texts in the given dir
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Winner", "Wikipedia_prev"
    ),
    # use tokenize() so examples run without a TreeTagger installation
    tagger="tokenize",
    lang="en"
  )
 
  # corpus with one category names "Source"
  myCorpus <- readCorpus(
    dir=file.path(
      path.package("tm.plugin.koRpus"), "examples", "corpus", "Winner"
    ),
    hierarchy=list(
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    tagger="tokenize",
    lang="en"
  )
 
  # two hieraryhical levels, "Topic" and "Source"
  myCorpus <- readCorpus(
    dir=file.path(path.package("tm.plugin.koRpus"), "examples", "corpus"),
    hierarchy=list(
      Topic=c(
        Winner="Reality Winner",
        Edwards="Natalie Edwards"
      ),
      Source=c(
        Wikipedia_prev="Wikipedia (old)",
        Wikipedia_new="Wikipedia (new)"
      )
    ),
    tagger="tokenize",
    lang="en"
  )
 
  # get hierarchy from directory tree
  myCorpus <- readCorpus(
    dir=file.path(path.package("tm.plugin.koRpus"), "examples", "corpus"),
    hierarchy=TRUE,
    tagger="tokenize",
    lang="en"
  )
  
  \dontrun{
    # if the same corpus is available as TIF compliant data frame
    myCorpus <- readCorpus(
      dir=myCorpus_df,
      hierarchy=list(
        Topic=c(
          Winner="Reality Winner",
          Edwards="Natalie Edwards"
        ),
        Source=c(
          Wikipedia_prev="Wikipedia (old)",
          Wikipedia_new="Wikipedia (new)"
        )
      ),
      lang="en",
      format="obj"
    )
  }
} else {}
}
\references{
[1] Text Interchange Formats (\url{https://github.com/ropensci/tif})
}
