% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_sequence_comparison}
\alias{plot.tna_sequence_comparison}
\title{Plot a Sequence Comparison}
\usage{
\method{plot}{tna_sequence_comparison}(
  x,
  n = 10,
  legend = TRUE,
  cells = TRUE,
  text_color = "white",
  digits = 2L,
  ...
)
}
\arguments{
\item{x}{A \code{tna_sequence_comparison} object.}

\item{n}{An \code{integer} giving the number of patterns to plot.
The default is \code{10}.}

\item{legend}{A \code{logical} value indicating whether to show the color scale
legend. The default is \code{TRUE}.}

\item{cells}{A \code{logical} value indicating whether to display the
numeric values in each cell. The default is \code{TRUE}.}

\item{text_color}{A \code{character} string specifying the text color to use for
the cell values. The default is \code{"white"}.}

\item{digits}{An \code{integer} specifying the number of digits for the cell
values.}

\item{...}{Not used.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a Sequence Comparison
}
\examples{
group <- c(rep("High", 1000), rep("Low", 1000))
comp <- compare_sequences(group_regulation, group)
plot(comp)

}
\seealso{
Model comparison functions
\code{\link{compare}()},
\code{\link{compare.group_tna}()},
\code{\link{compare_sequences}()},
\code{\link{plot.tna_comparison}()},
\code{\link{plot_compare}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{print.tna_comparison}()},
\code{\link{print.tna_sequence_comparison}()}
}
\concept{comparison}
