
#' Arrange agents into hierarchy
#'
#' Estimate agent hierarchy from a tally by assembling edges in order of decreasing weight and skipping cycle-creating ones.
#' The effect is a directed acyclic graph that can be topologically-sorted into an agent order, though this order may not be unique depending on how well the latent hierarchy is sampled and whether it even exists.
#' @param tally a \code{toporanga tally} object.
#' @returns A \code{toporanga_graph} object, representing the established graph.
#' @note The method may be stochastic if there are ties in weights.
#' @examples data(EcoHAB)
#' arrange(tally_log(EcoHAB$winner,EcoHAB$loser))
#' @export
arrange<-function(tally){
  l<-list_tally(tally)
  agents<-levels(l$a)
  if(length(l$a)==0)
    return(construct_graph(matrix(FALSE,length(agents),length(agents)),agents,seq_along(agents)))
  l[order(-l$w,sample(nrow(l))),]->l
  .Call(C_fdag,as.integer(l$a),as.integer(l$b),length(agents))->ans
  sample_toposort(construct_graph(matrix(ans[[2]],length(agents)),agents,ans[[3]]))
}

