
#' Diffuse the weights over indirect links.
#'
#' Uses the Schulze / widest path approach to re-express indirect domination into direct one.
#' For instance, if \eqn{A\rightarrow B} and \eqn{B\rightarrow C} both have weight 10, but \eqn{A\rightarrow C} has weight 3, it is gonna be corrected to 10 by this function. 
#' @param tally a \code{toporanga_tally} object.
#' @param blend a numerical factor to limit the effect of diffusion; weight of indirect path is multiplied by the given factor, while direct weights are not changed.
#' When set to 1, function behaves the same as \code{blend} was not given at all, when given 0, whole diffuse returns \code{tally} unchanged.
#' @returns A modified \code{toporanga_tally} object.
#' @export
diffuse<-function(tally,blend){
  m<-matrix_tally(tally)
  dm<-.Call(C_fw,m)
  if(!missing(blend)){
    stopifnot(length(blend)==1)
    stopifnot(blend>=0 && blend<=1)
    dm<-pmax(m,blend*dm)
  }
  dim(dm)<-dim(m)
  rownames(dm)<-colnames(dm)<-rownames(m)
  ans<-list(m=dm)
  class(ans)<-"toporanga_tally"
  ans
}

