% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imdb.R
\name{imdb_dataset}
\alias{imdb_dataset}
\title{IMDB movie review sentiment classification dataset}
\usage{
imdb_dataset(
  root,
  download = FALSE,
  split = "train",
  shuffle = (split == "train"),
  num_words = Inf,
  skip_top = 0,
  maxlen = Inf,
  start_char = 2,
  oov_char = 3,
  index_from = 4
)
}
\arguments{
\item{root}{path to the data location}

\item{download}{wether to download or not}

\item{split}{train, test or valid}

\item{shuffle}{whether to shuffle or not the dataset. \code{TRUE} if \code{split=="train"}}

\item{num_words}{Words are ranked by how often they occur (in the training set),
and only the num_words most frequent words are kept. Any less frequent word
will appear as oov_char value in the sequence data. If \code{Inf}, all words are
kept. Defaults to None, so all words are kept.}

\item{skip_top}{skip the top N most frequently occurring words (which may not be informative).
These words will appear as oov_char value in the dataset. Defaults to 0, so
no words are skipped.}

\item{maxlen}{int or \code{Inf}. Maximum sequence length. Any longer sequence will
be truncated. Defaults to Inf, which means no truncation.}

\item{start_char}{The start of a sequence will be marked with this character.
Defaults to 2, because 1 is usually the padding character.}

\item{oov_char}{int. The out-of-vocabulary character. Words that were cut out
because of the num_words or skip_top limits will be replaced with this character.}

\item{index_from}{int. Index actual words with this index and higher.}
}
\description{
The format of this dataset is meant to replicate that provided by
\href{https://keras.io/api/datasets/imdb/}{Keras}.
}
