% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlewb.R
\name{mlewb}
\alias{mlewb}
\title{Maximum likelihood estimation (MLE) for the three-parameter Weibull distribution.}
\usage{
mlewb(x, shape, scale, location)
}
\arguments{
\item{x}{vector of quantiles.}

\item{shape}{shape parameter, where \eqn{\beta > 0}.}

\item{scale}{scale parameter, where \eqn{\alpha > 0}.}

\item{location}{location parameter, where \eqn{\delta \ge 0}.}
}
\value{
the estimated shape, scale and location values of the three-parameter Weibull distribution.
}
\description{
This function for estimating parameter of the three-parameter Weibull distribution.
}
\note{
the result of this function may produce a Warning message, but not effect to the estimated parameter.
}
\examples{
x<- rtpwb(1000,2,3,1) #n=1000 large sample
mlewb(x,2,3,1)
x<- rtpwb(50,2,3,1) #n=50 medium sample
mlewb(x,2,3,1)
x<- rtpwb(10,2,3,1) #n=10 small sample
mlewb(x,2,3,1)
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 1, chapter 21. Wiley, New York.
}
