% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train.xgboost}
\alias{train.xgboost}
\title{train.xgboost}
\usage{
train.xgboost(
  formula,
  data,
  nrounds,
  evals = list(),
  custom_metric = NULL,
  verbose = 1,
  print_every_n = 1L,
  early_stopping_rounds = NULL,
  maximize = NULL,
  save_period = NULL,
  save_name = "xgboost.model",
  xgb_model = NULL,
  callbacks = list(),
  eval_metric = NULL,
  extra_params = NULL,
  booster = "gbtree",
  objective = NULL,
  eta = 0.3,
  gamma = 0,
  max_depth = 6,
  min_child_weight = 1,
  subsample = 1,
  colsample_bytree = 1,
  ...
)
}
\arguments{
\item{formula}{A model formula describing the response and predictors.}

\item{data}{A data frame containing the training data. Internally, it is converted to
an \code{xgb.DMatrix}.}

\item{nrounds}{Maximum number of boosting iterations.}

\item{evals}{A named list of \code{xgb.DMatrix} objects for evaluation during training.
Defaults to training data if empty.}

\item{custom_metric}{A custom evaluation function for xgboost.}

\item{verbose}{Controls verbosity: \code{0} = silent, \code{1} = progress printed.}

\item{print_every_n}{Print evaluation results every \code{print_every_n} iterations.}

\item{early_stopping_rounds}{Number of rounds with no improvement before stopping.}

\item{maximize}{Logical indicating if the evaluation metric should be maximized.}

\item{save_period}{Save the model every \code{save_period} rounds. Defaults to saving at the end.}

\item{save_name}{File name for saving the model.}

\item{xgb_model}{A previously trained xgboost model for continuation.}

\item{callbacks}{A list of callback functions for xgboost during training.}

\item{eval_metric}{Evaluation metric for xgboost (e.g., \code{"mlogloss"}, \code{"rmse"}).}

\item{extra_params}{Optional list of additional xgboost parameters.}

\item{booster}{Booster type: \code{"gbtree"} or \code{"gblinear"}. Default is \code{"gbtree"}.}

\item{objective}{Objective function for xgboost. If \code{NULL}, it's chosen automatically:
\itemize{
  \item Regression → \code{"reg:squarederror"}
  \item Binary classification → \code{"binary:logistic"}
  \item Multiclass → \code{"multi:softprob"}
}}

\item{eta}{Learning rate. Default is 0.3.}

\item{gamma}{Minimum loss reduction for a split. Default is 0.}

\item{max_depth}{Maximum depth of trees. Default is 6.}

\item{min_child_weight}{Minimum sum of instance weight in a child.}

\item{subsample}{Subsample ratio for training instances. Default is 1.}

\item{colsample_bytree}{Subsample ratio of columns per tree. Default is 1.}

\item{...}{Additional arguments for \code{xgb.train}.}
}
\value{
An object of class \code{xgb.Booster.prmdt} containing:
\itemize{
  \item The trained xgboost model.
  \item Metadata used by traineR for prediction output.
}
}
\description{
This function wraps \code{\link[xgboost]{xgb.train}} to standardize model
training within the traineR framework. It automatically handles preprocessing,
parameter configuration, multiclass settings, and metadata generation for predictions.
}
\seealso{
\code{\link[xgboost]{xgb.train}}, \code{\link[xgboost]{xgb.DMatrix}}
}
