% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_plot.R
\name{autoplot.filled_trait}
\alias{autoplot.filled_trait}
\title{Coverage plot of filled Traits}
\usage{
\method{autoplot}{filled_trait}(object, other_col_how, ...)
}
\arguments{
\item{object}{output from \code{trait_fill()}.}

\item{other_col_how}{what to do with the other columns in other data.
Options are to \code{filter} by one of the columns, add them to the x-\code{axis},
\code{facet} by them, or to \code{ignore}.}

\item{...}{optional filters for use with \code{other_col_how = "filter"}}
}
\value{
a ggplot2 plot
}
\description{
Function calculates the trait coverage of the community
for each level of the sampling hierarchy and makes a barplot.

Shows at which level the data are coming from in each plot.
}
\examples{
require("ggplot2")
data(community)
data(trait)
filled_traits <- trait_fill(
  comm = community, traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)
autoplot(filled_traits)
}
