% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{LehmannVS}
\alias{LehmannVS}
\title{Optimal subset selection in a Lehmann-type transformation model}
\usage{
LehmannVS(
  formula,
  data,
  supp_max = NULL,
  k_max = NULL,
  thresh = NULL,
  init = TRUE,
  m_max = 10,
  parallel = FALSE,
  future_args = list(strategy = "multisession", workers = supp_max),
  ...
)
}
\arguments{
\item{formula}{object of class \code{"formula"}.}

\item{data}{data frame containing the variables in the model.}

\item{supp_max}{maximum support which to call \code{abess_tram} with.}

\item{k_max}{maximum support size to consider during the splicing algorithm.
Defaults to \code{supp}.}

\item{thresh}{threshold when to stop splicing. Defaults to
0.01 * \code{supp} * p * log(log(n)) / n$, where p denotes the number of predictors
and n the sample size.}

\item{init}{initialize active set. Defaults to \code{TRUE} and initializes the
active set with those covariates that are most correlated with score residuals
of an unconditional \code{modFUN(update(formula, . ~ 1))}.}

\item{m_max}{maximum number of iterating the splicing algorithm.}

\item{parallel}{toggle for parallel computing via
\code{\link[future.apply]{future_lapply}}}

\item{future_args}{arguments passed to \code{\link[future]{plan}}; defaults
to a \code{"multisession"} with \code{supp_max} workers}

\item{...}{Additional arguments supplied to \code{Lehmann}}
}
\value{
See \code{\link[tramvs]{tramvs}}
}
\description{
Optimal subset selection in a Lehmann-type transformation model
}
