% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialize.R
\name{serialize}
\alias{serialize}
\alias{ExportedTranslator}
\alias{ExportedText}
\alias{ExportedLocation}
\alias{ExportedTranslations}
\alias{serialize_translations}
\alias{deserialize}
\alias{deserialize_translations}
\alias{export_translations}
\alias{export}
\alias{export.Translator}
\alias{export.Text}
\alias{export.Location}
\alias{assert.ExportedTranslator}
\alias{assert.ExportedText}
\alias{assert.ExportedLocation}
\alias{assert.ExportedTranslations}
\alias{import}
\alias{import.ExportedTranslator}
\alias{import.ExportedText}
\alias{import.ExportedLocation}
\alias{import.ExportedTranslations}
\alias{import.default}
\alias{format_errors}
\title{Serialize Objects}
\usage{
serialize(x, ...)

serialize_translations(tr = translator(), lang = "")

deserialize(string = "")

deserialize_translations(string = "", tr = NULL)

export_translations(tr = translator(), lang = "")

export(x, ...)

\method{export}{Translator}(x, ...)

\method{export}{Text}(x, id = uuid(), set_translations = FALSE, ...)

\method{export}{Location}(x, id = uuid(), ...)

\method{assert}{ExportedTranslator}(x, throw_error = TRUE, ...)

\method{assert}{ExportedText}(x, throw_error = TRUE, ...)

\method{assert}{ExportedLocation}(x, throw_error = TRUE, ...)

\method{assert}{ExportedTranslations}(x, throw_error = TRUE, ...)

import(x, ...)

\method{import}{ExportedTranslator}(x, ...)

\method{import}{ExportedText}(x, ...)

\method{import}{ExportedLocation}(x, ...)

\method{import}{ExportedTranslations}(x, tr = NULL, ...)

\method{import}{default}(x, ...)

format_errors(errors = character(), id = uuid(), throw_error = TRUE)
}
\arguments{
\item{x}{Any \R object.}

\item{...}{Further arguments passed to, or from other methods.}

\item{tr}{A \code{\link{Translator}} object.

This argument is \code{NULL} by default for \code{\link[=deserialize_translations]{deserialize_translations()}} and
\code{\link[=import.ExportedTranslations]{import.ExportedTranslations()}}. If a \code{\link{Translator}} object
is passed to these functions, they will import translations and further
register them (as long as they correspond to an existing source text).}

\item{lang}{A non-empty and non-NA character string. The underlying language.

A language is usually a code (of two or three letters) for a native
language name. While users retain full control over codes, it is best
to use language codes stemming from well-known schemes such as
\href{https://en.wikipedia.org/wiki/IETF_language_tag}{IETF BCP 47}, or
\href{https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes}{ISO 639-1}
to maximize portability and cross-compatibility.}

\item{string}{A non-empty and non-NA character string. Contents
to deserialize.}

\item{id}{A non-empty and non-NA character string. A unique identifier for
the underlying object. It is used for validation purposes.}

\item{set_translations}{A non-NA logical value. Should translations be
included in the resulting \code{\link[=export]{ExportedText}} object? If \code{FALSE},
field \code{Translations} is set equal to \code{NULL}.}

\item{throw_error}{A non-NA logical value. Should an error be thrown? If so,
\code{\link[=stops]{stops()}} is called. Otherwise, error messages are returned as a character
vector (possibly empty).}

\item{errors}{A non-empty character vector of non-NA values. Error
message(s) describing why object(s) are invalid.}
}
\value{
See other sections for further information.

\code{\link[=serialize]{serialize()}}, and \code{\link[=serialize_translations]{serialize_translations()}} return a character string.

\code{\link[=export]{export()}} returns a named list of S3 class
\itemize{
\item \code{\link[=export]{ExportedTranslator}} if \code{x} is a \code{\link{Translator}}
object,
\item \code{\link[=export]{ExportedText}} if \code{x} is a \code{\link{Text}} object, or
\item \code{\link[=export]{ExportedLocation}} if \code{x} is a \code{\link{Location}} object.
}

\code{\link[=export_translations]{export_translations()}} returns an \code{\link[=export]{ExportedTranslations}} object.

\code{\link[=deserialize]{deserialize()}} and \code{\link[=import]{import()}} return
\itemize{
\item a \code{\link{Translator}} object if \code{x} is a valid
\code{\link[=export]{ExportedTranslator}} object,
\item a \code{\link{Text}} object if \code{x} is a valid \code{\link[=export]{ExportedText}}
object, or
\item a \code{\link{Location}} object if \code{x} a valid
\code{\link[=export]{ExportedLocation}} object.
}

\code{\link[=deserialize_translations]{deserialize_translations()}} and \code{\link[=import.ExportedTranslations]{import.ExportedTranslations()}} return an
\code{\link[=export]{ExportedTranslations}} object. They further register imported
translations if a \code{\link{Translator}} object is passed to \code{tr}.
\itemize{
\item Translations must correspond to an existing source text (a registered
\code{\link{Text}} object). Otherwise, they are skipped.
\item The value passed to \code{tr} is updated \strong{by reference} and is not returned.
}

\code{\link[=import.default]{import.default()}} is used for its side-effect of throwing an error for
unsupported objects.

\code{\link[=assert.ExportedTranslator]{assert.ExportedTranslator()}},
\code{\link[=assert.ExportedText]{assert.ExportedText()}},
\code{\link[=assert.ExportedLocation]{assert.ExportedLocation()}}, and
\code{\link[=assert.ExportedTranslations]{assert.ExportedTranslations()}} return a character vector, possibly empty.
If \code{throw_error} is \code{TRUE}, an error is thrown if an object is invalid.

\code{\link[=format_errors]{format_errors()}} returns a character vector, and outputs its contents as
an error if \code{throw_error} is \code{TRUE}.
}
\description{
Convert \code{\link{Translator}} objects, \code{\link{Text}} objects, and
\code{\link{Location}} objects to a \link[yaml:as.yaml]{YAML} object, or
vice-versa.

Convert translations contained by a \code{\link{Translator}} object to
a custom textual representation (a \link[=flat_serialize]{FLAT} object), or
vive-versa.
}
\details{
The information contained within a \code{\link{Translator}} object is
split by default. Unless \code{set_translations} is \code{TRUE}, translations are
serialized independently from other fields. This is useful when creating
Translator files and translations files.

While \code{\link[=serialize]{serialize()}} and \code{\link[=serialize_translations]{serialize_translations()}} are distinct, they share
a common \emph{design} and perform the same \emph{thing}, at least conceptually. The
same is true for \code{\link[=deserialize]{deserialize()}} and \code{\link[=deserialize_translations]{deserialize_translations()}}. These 4
functions are those that should be used in almost all circumstances.
\subsection{Serialization}{

The data serialization process performed by \code{\link[=serialize]{serialize()}} and
\code{\link[=serialize_translations]{serialize_translations()}} is internally broken down into 2 steps: objects
are first \emph{exported} before being \emph{serialized}.

\code{\link[=export]{export()}} and \code{\link[=export_translations]{export_translations()}} are \emph{preserializing mechanisms} that
convert objects into \emph{transient} objects that ease the conversion process.
They are never returned to the user: \code{\link[=serialize]{serialize()}}, and
\code{\link[=serialize_translations]{serialize_translations()}} immediately transform them into character strings.

\code{\link[=serialize]{serialize()}} returns a \link[yaml:as.yaml]{YAML object}.

\code{\link[=serialize_translations]{serialize_translations()}} returns a \link[=flat_serialize]{FLAT object}.
}

\subsection{Deserialization}{

The data deserialization process performed by \code{\link[=deserialize]{deserialize()}} and
\code{\link[=deserialize_translations]{deserialize_translations()}} is internally broken down into 3 steps: objects
are first \emph{deserialized}, then \emph{validated} and finally, \emph{imported}.

\code{\link[=deserialize]{deserialize()}} and \code{\link[=deserialize_translations]{deserialize_translations()}} are
\emph{raw deserializer mechanisms}: \code{string} is converted into an \R named list
that is \strong{presumed} to be an \emph{exported} object. \code{\link[=deserialize]{deserialize()}} relies on
\href{https://yaml.org/spec/1.1/#id858600}{YAML tags} to infer the class of each
object.

The contents of the \emph{transient} objects is thoroughly checked with an
\code{\link[=assert]{assert()}} method (based on the underlying presumed class). Valid objects
are \emph{imported} back into an appropriate \R object with \code{\link[=import]{import()}}.

Custom fields and comments added by users to serialized objects are ignored.
}

\subsection{Formatting errors}{

\code{\link[=assert]{assert()}} methods accumulate error messages before returning, or throwing
them. \code{\link[=format_errors]{format_errors()}} is a helper function that eases this process. It
exists to avoid repeting code in each method. There is no reason to call
it outside of \code{\link[=assert]{assert()}} methods.
}
}
\note{
Dividing the serialization and deserialization processes into multiple steps
helps keeping the underlying functions short, and easier to test.
}
\section{Exported Objects}{

An exported object is a named list of S3 class
\code{\link[=export]{ExportedTranslator}},
\code{\link[=export]{ExportedText}},
\code{\link[=export]{ExportedLocation}}, or
\code{\link[=export]{ExportedTranslations}} and
always having a \code{tag} attribute whose value is equal to the super-class of
\code{x}.

There are four main differences between an object and its \emph{exported}
counterpart.
\enumerate{
\item Field names are slightly more verbose.
\item Source text is treated independently from translations.
\item Unset fields are set equal to \code{NULL} (a \code{~} in YAML).
\item Each object has an \code{Identifier} used to locate errors.
}

The correspondance between objects is self-explanatory.
\itemize{
\item See class \code{\link{Translator}} for more information on class
\code{\link[=export]{ExportedTranslator}}.
\item See class \code{\link{Text}} for more information on class
\code{\link[=export]{ExportedText}}.
\item See class \code{\link{Location}} for more information on class
\code{\link[=export]{ExportedLocation}}.
}

You may also explore provided examples below.
\subsection{The \code{ExportedTranslations} Class}{

\code{\link[=export]{ExportedTranslations}} objects are created from a
\code{\link{Translator}} object with \code{\link[=export_translations]{export_translations()}}. Their purpose
is to restructure translations by language. They are different from other
exported objects because there is no corresponding \code{Translations} class.

An \code{\link[=export]{ExportedTranslations}} object is a named list of S3 class
\code{\link[=export]{ExportedTranslations}} containing the following elements.

\describe{
\item{\code{Identifier}}{The unique identifier of argument \code{tr}. See
\code{\link[=Translator]{Translator$id}} for more information.}
\item{\verb{Language Code}}{The value of argument \code{lang}.}
\item{\code{Language}}{The translation's language. See
\code{\link[=Translator]{Translator$native_languages}} for more information.}
\item{\verb{Source Language}}{The source text's language. See
\code{\link[=Translator]{Translator$source_langs}} for more information.}
\item{\code{Translations}}{A named list containing further named lists. Each
sublist contains two values:
\describe{
\item{\verb{Source Text}}{A non-empty and non-NA character string.}
\item{\code{Translation}}{A non-empty and non-NA character string.}
}
See \code{\link[=Text]{Text$translations}} for more information.}
}

Unavailable translations are automatically replaced by a placeholder that
depends on whether they are exported or imported.
}
}

\seealso{
\href{https://yaml.org/spec/1.1/}{Official YAML 1.1 specification},
\code{\link[yaml:as.yaml]{yaml::as.yaml()}},
\code{\link[yaml:yaml.load]{yaml::yaml.load()}},
\code{\link[=flat_serialize]{flat_serialize()}},
\code{\link[=flat_deserialize]{flat_deserialize()}},
\code{\link[=translator_read]{translator_read()}},
\code{\link[=translator_write]{translator_write()}},
\code{\link[=translations_read]{translations_read()}},
\code{\link[=translations_write]{translations_write()}}
}
\keyword{internal}
