% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-strings.R
\name{str_to}
\alias{str_to}
\alias{str_to.default}
\alias{str_trim}
\alias{str_wrap}
\title{Character String Utilities}
\usage{
str_to(x, ...)

\method{str_to}{default}(x, quote_values = FALSE, last_sep = ", or ", ...)

str_trim(x = character(), width = 80L)

str_wrap(x = character(), width = 80L)
}
\arguments{
\item{x}{Any \R object for \code{\link[=str_to]{str_to()}}. A character vector otherwise.}

\item{...}{Further arguments passed to, or from other methods.}

\item{quote_values}{A non-NA logical value. Should elements of \code{x} be quoted?}

\item{last_sep}{A non-empty and non-NA character string separating the last
and penultimate elements.}

\item{width}{A non-NA integer value. The target width for individual
elements of \code{x}. \code{\link[=str_trim]{str_trim()}} takes 3 more characters into account for the
suffix it inserts (\code{...}).}
}
\value{
\code{\link[=str_to]{str_to()}} and \code{\link[=str_wrap]{str_wrap()}} return a character string.

\code{\link[=str_trim]{str_trim()}} returns a character vector having the same length as \code{x}.
}
\description{
\code{\link[=str_to]{str_to()}} converts an \R object to a character string. It is a slightly
more flexible alternative to \code{\link[base:toString]{base::toString()}}.

\code{\link[=str_trim]{str_trim()}} wraps \code{\link[base:strtrim]{base::strtrim()}} and further adds a \code{...} suffix to
each trimmed element.

\code{\link[=str_wrap]{str_wrap()}} wraps \code{\link[base:strwrap]{base::strwrap()}} and ensures a character string is
returned.
}
\details{
\code{\link[=str_to]{str_to()}} concatenates all elements with \code{", "}, except for the last
one. See argument \code{last_sep}.

\code{\link[=str_wrap]{str_wrap()}} preserves existing paragraph separators (\code{"\\n\\n"}).
}
\seealso{
Other utility functions: 
\code{\link{format_vector}()},
\code{\link{stops}()},
\code{\link{vapply_1l}()}
}
\concept{utility functions}
\keyword{internal}
