% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxFuncs.R
\name{getDescMatrix}
\alias{getDescMatrix}
\alias{getAncVec}
\alias{getNodesOfDepth}
\alias{symBucketLexicoSort}
\alias{getAllAncestors}
\alias{cPL_inv}
\alias{maxDepthLeaf}
\alias{get.subtreesize}
\alias{getlca}
\alias{we_eth}
\alias{getfurranks}
\alias{getsubtree}
\alias{is_binary}
\alias{is_phylo}
\alias{tree_decomposition}
\alias{tree_merge}
\alias{treenumber}
\alias{treenumber_inv}
\alias{auxE_l_X}
\title{Auxiliary functions}
\usage{
getDescMatrix(tree)

getAncVec(tree)

getNodesOfDepth(mat, root, n)

symBucketLexicoSort(workLabs)

getAllAncestors(tree, v)

cPL_inv(label)

maxDepthLeaf(tree, v = length(tree$tip.label) + 1)

get.subtreesize(tree)

getlca(tree, v, w)

we_eth(n)

getfurranks(tree)

getsubtree(tree, subroot)

is_binary(tree)

is_phylo(tree)

tree_decomposition(tree)

tree_merge(tree1, tree2)

treenumber(tree)

treenumber_inv(treenum)

auxE_l_X(subX, Xset)
}
\arguments{
\item{tree}{A rooted tree in phylo format, >= 2 leaves}

\item{mat}{Descendants matrix from \code{getDescMatrix}}

\item{root}{Number (label) of the root of the tree}

\item{n}{Number of leaves of the tree}

\item{workLabs}{numeric matrix (2 columns)}

\item{v}{A vertex of the tree.}

\item{label}{A Colijn-Plazotta label of desired tree, a positive integer.}

\item{w}{A vertex of the tree.}

\item{subroot}{A vertex of the tree. It is not recommended to use
leaves as subroots.}

\item{tree1}{A rooted tree in phylo format.}

\item{tree2}{A rooted tree in phylo format.}

\item{treenum}{An integer denoting the tree number of the sought tree.}

\item{subX}{integer >=1, size of the subsets of X.}

\item{Xset}{Vector (multiset) of numeric values.}
}
\value{
\code{desc_mat} numeric matrix

\code{anc_vec} numeric vector

\code{nodes_of_depth} numeric matrix

\code{ranking} numeric vector

\code{vectorWithAncs} numeric vector
}
\description{
\code{getDescMatrix} - Creates a matrix that contains the descendants of
node \eqn{i} in row \eqn{i}.

\code{getAncVec} - Creates a vector that contains the parent (direct ancestor) of
node \eqn{i} at position \eqn{i}.

\code{getNodesOfDepth} - Creates a matrix that contains the nodes of
depth \eqn{i} in row \eqn{i}.

\code{symBucketLexicoSort} - Sorts the pairs of numbers lexicographically and
returns ranking. Uses bucket sort.

\code{getAllAncestors} - Returns all ancestors of \eqn{v} including \eqn{v} itself.

\code{cPL_inv} - Returns the binary tree that belongs to the input label in an incomplete
Newick format.

\code{maxDepthLeaf} - Returns the maximumy< depth of a leaf in the subtree that
is rooted at \eqn{v}.

\code{get.subtreesize} - Creates a vector that contains at the \eqn{i}-th position
the number of leaves in the pending subtree rooted at \eqn{i}.

\code{getlca} - Returns the name of the lowest common ancestor of the two
input vertices \eqn{v} and \eqn{w}.

\code{we_eth} - Returns the Wedderburn-Etherington number \eqn{we(n)}
for a given non-negative integer \eqn{n}.

\code{getfurranks} - Returns for each vertex \eqn{i} the Furnas rank of the
subtree rooted at \eqn{i}.

\code{getsubtree} - Returns the pending subtree (in phylo format) that is
rooted at the input vertex. If the input vertex is a leaf, the function returns
the standard tree for \eqn{n=1} (with 1 edge).

\code{is_binary} - Returns TRUE if the input tree is binary and FALSE otherwise.

\code{is_phylo} - Tests all requirements of the phylo format, and returns TRUE
if the tree is correctly formatted, else FALSE with detailed feedback on the
features that are not met.

\code{tree_decomposition} - Returns a list of length two, which
contains the two pending subtrees that are rooted at the children of the root
of the input tree. The
smaller one (according to the number of leaves) is stated first.

\code{tree_merge} - Returns a rooted tree \eqn{T} in phylo
format, which contains the input trees \eqn{tree1} and \eqn{tree2} as
"left" and "right" maximal pending subtrees.

\code{treenumber} - Returns the unique tree number \eqn{tn(T)} of the given tree.
\eqn{tn(T)} is the rank of the tree \eqn{T} among all
rooted binary trees in the left-light rooted ordering. It can
be calculated as follows: \deqn{tn(T)=F(T) + \sum_{i=1}^{n-1} we(i)}{
tn(T)=F(T) + \sum we(i) over 1=i<=n-1}
in which \eqn{n} is the number of leaves in \eqn{T}, \eqn{F(T)} is the Furnas
rank of \eqn{T}, i.e. the rank of \eqn{T} in the left-light rooted ordering
of all rooted binary trees with \eqn{n} leaves, and \eqn{we(i)} is the
Wedderburn-Etherington number of \eqn{i}.
The concept of assigning each rooted binary tree a unique tree number allows
to store many trees with minimal storage use.
For \eqn{n=1} the function returns \eqn{tn(T)=1} and a warning.

\code{treenumber_inv} - Returns the unique tree (in phylo format) for
the given tree number.

\code{auxE_l_X} - Returns the sum of all products of l different values in X.
}
\examples{
mat <- cbind(c(7,7,6,5,5,6),c(1,2,3,4,6,7))
tree <- list(edge=mat, tip.label=c("","","",""), Nnode=3)
getDescMatrix(tree)
mat <- cbind(c(5,5,5,5),c(1,2,3,4))
tree <- list(edge=mat, tip.label=c("","","",""), Nnode=1)
getDescMatrix(tree)
getAncVec(tree)
getNodesOfDepth(mat=getDescMatrix(tree),root=length(tree$tip.label)+1,
n=length(tree$tip.label))
myWorkLabs <- cbind(c(0,1,2,3,1,0),c(0,2,2,4,1,0))
symBucketLexicoSort(myWorkLabs)
getAllAncestors(tree,v=6)
cPL_inv(label=6)
maxDepthLeaf(tree,v=6)
get.subtreesize(tree)
getlca(tree,1,2)
we_eth(5)
getfurranks(tree)
getsubtree(tree,4)
is_binary(ape::read.tree(text="((((,),),(,)),(((,),),(,)));"))
is_phylo(ape::read.tree(text="((((,),),(,)),(((,),),(,)));"))
tree_decomposition(ape::read.tree(text="((((,),),(,)),(((,),),(,)));"))
treeA <- ape::read.tree(text="(((,),),(,));")
treeB <- ape::read.tree(text="((,),);")
tree_merge(treeA, treeB)
treenumber(ape::read.tree(text="((((,),),(,)),(((,),),(,)));"))
treenumber_inv(192)
auxE_l_X(subX=3,Xset=c(1,1,2,2))
}
\author{
Sophie Kersting, Luise Kuehn and Lina Herbst
}
