#' Fictitious  Business Statistics Data
#'
#' Fictitious (aggregated) business statistics data. The index variables (\code{NACE1} to \code{NACE4}) are derived from the Statistical Classification of Economic Activities in the European Community (NACE). The variables \code{turnover(.prev)} and \code{employees(.prev)} have values for NACE codes in the business economy domain only.
#'
#' @name business
#' @references 
#' \href{https://en.wikipedia.org/wiki/Statistical_Classification_of_Economic_Activities_in_the_European_Community}{Statistical Classification of Economic Activities in the European Community (NACE)}
#' \href{https://ec.europa.eu/eurostat/web/structural-business-statistics}{Eurostat - Structural business statistics (SBS)}
{}

#' GNI 2014 Data
#' 
#' Gross national income (per capita) in dollars and population totals per country in 2014. 
#' 
#' The GNI numbers from the World Bank are based on the Atlas. The population data are taken from Natural Earth Data.
#'
#' @name GNI2014
#' @references 
#' \href{https://www.worldbank.org/en/home}{The World Bank - GNI per capita ranking}
#' \href{https://www.naturalearthdata.com/}{Natural Earth Data}
{}
