% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframe_loadR.R
\name{dataf_parsr}
\alias{dataf_parsr}
\title{Detect file format of taxon file}
\usage{
dataf_parsr(dataf)
}
\arguments{
\item{dataf}{A data frame with one column containing the taxon name of tips in phylogenetic tree. Optionally, a second column can indicate the maximum age of the tip. If the tip is extant, use 0.0 as the age. Can be CSV or TSV.}
}
\value{
tax_frame Dataframe containing the total set of tips on the tree
}
\description{
Detect file format of the total taxon list (molecular, morphological, and stratigraphic) and maximum age of fossil, see RevBayes total
-evidence fossil file for an example of this.
}
\examples{
\dontrun{tax_frame <- dataf_parsr(dataf)}
}
