% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_count_multi_group_tests.R
\encoding{UTF-8}
\name{run_count_multi_group_tests}
\alias{run_count_multi_group_tests}
\title{Statistical Test for Count Data (Multi-Groups) / Statistischer Test fuer Zaehldaten (Mehrere Gruppen)}
\usage{
run_count_multi_group_tests(
  df,
  value_col = ".value",
  group_col = "jahr",
  alpha = 0.05,
  phi = 1.5,
  effect_size = FALSE,
  report_assumptions = FALSE
)
}
\arguments{
\item{df}{A data frame containing the data, already prepared (e.g., by prepare_group_data).}

\item{value_col}{Name of the column containing count values. Default is ".value".}

\item{group_col}{Name of the grouping variable. Default is "jahr".}

\item{alpha}{Significance level for hypothesis testing. Default is 0.05.}

\item{phi}{Common heuristic for overdispersion. Default is 1.5.}

\item{effect_size}{Logical. Whether to calculate and return a simple effect size (e.g., Pseudo R-squared).}

\item{report_assumptions}{Logical. Whether to report basic assumption diagnostics (e.g., overdispersion status).}
}
\value{
A list containing test results (p-value, significant groups, chosen method).
}
\description{
This function performs a simple comparison of count data across three or more groups.
It uses Poisson or Negative Binomial regression, considering overdispersion,
followed by an ANOVA-like test for the overall group effect and optional post-hoc tests.
Focus is on overall p-value and identifying differing groups, without complex model interpretation.
}
\details{
Diese Funktion fuehrt einen einfachen Vergleich von Zaehldaten bei drei oder mehr Gruppen durch.
Sie verwendet Poisson- oder Negative Binomial-Regression (abhaengig von Ueberdispersion),
gefolgt von einem ANOVA-aehnlichen Test fuer den Gesamtgruppeneffekt und optionalen Post-Hoc-Tests.
Der Schwerpunkt liegt auf dem Gesamt-p-Wert und der Identifizierung unterschiedlicher Gruppen,
ohne komplexe Modellinterpretation.
}
\examples{
set.seed(123)
data <- data.frame(
.value = c(rpois(50, 3), rpois(50, 5), rpois(50, 4)),
jahr = factor(rep(c("2020", "2021", "2022"), each = 50))
)

result <- run_count_multi_group_tests(
df = data,
value_col = ".value",
group_col = "jahr",
alpha = 0.05,
phi = 1.5,
effect_size = TRUE,
report_assumptions = TRUE
)

print(result$p_value)
print(result$significant_pairwise_differences)
print(result$effect_size)

}
