// Generated by rstantools.  Do not edit by hand.

/*
    trialr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    trialr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with trialr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_EffTox_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_EffTox");
    reader.add_event(115, 113, "end", "model_EffTox");
    return reader;
}
template <typename T0__, typename T1__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type
log_joint_pdf(const std::vector<T0__>& coded_doses,
                  const std::vector<T1__>& coded_doses_squ,
                  const int& num_patients,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& eta,
                  const T11__& psi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        local_scalar_t__ p(DUMMY_VAR__);
        (void) p;  // dummy to suppress unused var warning
        stan::math::initialize(p, DUMMY_VAR__);
        stan::math::fill(p, DUMMY_VAR__);
        current_statement_begin__ = 10;
        stan::math::assign(p, 0);
        current_statement_begin__ = 11;
        for (int j = 1; j <= num_patients; ++j) {
            {
            current_statement_begin__ = 12;
            local_scalar_t__ prob_eff(DUMMY_VAR__);
            (void) prob_eff;  // dummy to suppress unused var warning
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff, DUMMY_VAR__);
            current_statement_begin__ = 13;
            local_scalar_t__ prob_tox(DUMMY_VAR__);
            (void) prob_tox;  // dummy to suppress unused var warning
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox, DUMMY_VAR__);
            current_statement_begin__ = 14;
            local_scalar_t__ p_j(DUMMY_VAR__);
            (void) p_j;  // dummy to suppress unused var warning
            stan::math::initialize(p_j, DUMMY_VAR__);
            stan::math::fill(p_j, DUMMY_VAR__);
            current_statement_begin__ = 15;
            stan::math::assign(prob_eff, inv_logit(((gamma + (zeta * get_base1(coded_doses, get_base1(doses, j, "doses", 1), "coded_doses", 1))) + (eta * get_base1(coded_doses_squ, get_base1(doses, j, "doses", 1), "coded_doses_squ", 1)))));
            current_statement_begin__ = 16;
            stan::math::assign(prob_tox, inv_logit((alpha + (beta * get_base1(coded_doses, get_base1(doses, j, "doses", 1), "coded_doses", 1)))));
            current_statement_begin__ = 17;
            stan::math::assign(p_j, ((((pow(prob_eff, get_base1(eff, j, "eff", 1)) * pow((1. - prob_eff), (1. - get_base1(eff, j, "eff", 1)))) * pow(prob_tox, get_base1(tox, j, "tox", 1))) * pow((1. - prob_tox), (1. - get_base1(tox, j, "tox", 1)))) + ((((((pow(-(1.), (get_base1(eff, j, "eff", 1) + get_base1(tox, j, "tox", 1))) * prob_eff) * prob_tox) * (1. - prob_eff)) * (1. - prob_tox)) * (stan::math::exp(psi) - 1.)) / (stan::math::exp(psi) + 1.))));
            current_statement_begin__ = 21;
            stan::math::assign(p, (p + stan::math::log(p_j)));
            }
        }
        current_statement_begin__ = 23;
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct log_joint_pdf_functor__ {
    template <typename T0__, typename T1__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
        typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type
    operator()(const std::vector<T0__>& coded_doses,
                  const std::vector<T1__>& coded_doses_squ,
                  const int& num_patients,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& eta,
                  const T11__& psi, std::ostream* pstream__) const {
        return log_joint_pdf(coded_doses, coded_doses_squ, num_patients, eff, tox, doses, alpha, beta, gamma, zeta, eta, psi, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_EffTox
  : public stan::model::model_base_crtp<model_EffTox> {
private:
        double alpha_mean;
        double alpha_sd;
        double beta_mean;
        double beta_sd;
        double gamma_mean;
        double gamma_sd;
        double zeta_mean;
        double zeta_sd;
        double eta_mean;
        double eta_sd;
        double psi_mean;
        double psi_sd;
        int num_doses;
        std::vector<double> real_doses;
        double p;
        double eff0;
        double tox1;
        double efficacy_hurdle;
        double toxicity_hurdle;
        int num_patients;
        std::vector<int> eff;
        std::vector<int> tox;
        std::vector<int> doses;
        std::vector<double> coded_doses;
        std::vector<double> coded_doses_squ;
        double mean_log_dose;
public:
    model_EffTox(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_EffTox(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_EffTox_namespace::model_EffTox";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "alpha_sd", alpha_sd, 0);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "beta_sd", beta_sd, 0);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "gamma_mean", "double", context__.to_vec());
            gamma_mean = double(0);
            vals_r__ = context__.vals_r("gamma_mean");
            pos__ = 0;
            gamma_mean = vals_r__[pos__++];
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "gamma_sd", "double", context__.to_vec());
            gamma_sd = double(0);
            vals_r__ = context__.vals_r("gamma_sd");
            pos__ = 0;
            gamma_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "gamma_sd", gamma_sd, 0);
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "zeta_mean", "double", context__.to_vec());
            zeta_mean = double(0);
            vals_r__ = context__.vals_r("zeta_mean");
            pos__ = 0;
            zeta_mean = vals_r__[pos__++];
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "zeta_sd", "double", context__.to_vec());
            zeta_sd = double(0);
            vals_r__ = context__.vals_r("zeta_sd");
            pos__ = 0;
            zeta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "zeta_sd", zeta_sd, 0);
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "eta_mean", "double", context__.to_vec());
            eta_mean = double(0);
            vals_r__ = context__.vals_r("eta_mean");
            pos__ = 0;
            eta_mean = vals_r__[pos__++];
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "eta_sd", "double", context__.to_vec());
            eta_sd = double(0);
            vals_r__ = context__.vals_r("eta_sd");
            pos__ = 0;
            eta_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "eta_sd", eta_sd, 0);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "psi_mean", "double", context__.to_vec());
            psi_mean = double(0);
            vals_r__ = context__.vals_r("psi_mean");
            pos__ = 0;
            psi_mean = vals_r__[pos__++];
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "psi_sd", "double", context__.to_vec());
            psi_sd = double(0);
            vals_r__ = context__.vals_r("psi_sd");
            pos__ = 0;
            psi_sd = vals_r__[pos__++];
            check_greater_or_equal(function__, "psi_sd", psi_sd, 0);
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_doses", num_doses, 1);
            current_statement_begin__ = 43;
            validate_non_negative_index("real_doses", "num_doses", num_doses);
            context__.validate_dims("data initialization", "real_doses", "double", context__.to_vec(num_doses));
            real_doses = std::vector<double>(num_doses, double(0));
            vals_r__ = context__.vals_r("real_doses");
            pos__ = 0;
            size_t real_doses_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < real_doses_k_0_max__; ++k_0__) {
                real_doses[k_0__] = vals_r__[pos__++];
            }
            size_t real_doses_i_0_max__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < real_doses_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "real_doses[i_0__]", real_doses[i_0__], 0);
            }
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "p", "double", context__.to_vec());
            p = double(0);
            vals_r__ = context__.vals_r("p");
            pos__ = 0;
            p = vals_r__[pos__++];
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "eff0", "double", context__.to_vec());
            eff0 = double(0);
            vals_r__ = context__.vals_r("eff0");
            pos__ = 0;
            eff0 = vals_r__[pos__++];
            current_statement_begin__ = 47;
            context__.validate_dims("data initialization", "tox1", "double", context__.to_vec());
            tox1 = double(0);
            vals_r__ = context__.vals_r("tox1");
            pos__ = 0;
            tox1 = vals_r__[pos__++];
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "efficacy_hurdle", "double", context__.to_vec());
            efficacy_hurdle = double(0);
            vals_r__ = context__.vals_r("efficacy_hurdle");
            pos__ = 0;
            efficacy_hurdle = vals_r__[pos__++];
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "toxicity_hurdle", "double", context__.to_vec());
            toxicity_hurdle = double(0);
            vals_r__ = context__.vals_r("toxicity_hurdle");
            pos__ = 0;
            toxicity_hurdle = vals_r__[pos__++];
            current_statement_begin__ = 51;
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            check_greater_or_equal(function__, "num_patients", num_patients, 0);
            current_statement_begin__ = 52;
            validate_non_negative_index("eff", "num_patients", num_patients);
            context__.validate_dims("data initialization", "eff", "int", context__.to_vec(num_patients));
            eff = std::vector<int>(num_patients, int(0));
            vals_i__ = context__.vals_i("eff");
            pos__ = 0;
            size_t eff_k_0_max__ = num_patients;
            for (size_t k_0__ = 0; k_0__ < eff_k_0_max__; ++k_0__) {
                eff[k_0__] = vals_i__[pos__++];
            }
            size_t eff_i_0_max__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "eff[i_0__]", eff[i_0__], 0);
                check_less_or_equal(function__, "eff[i_0__]", eff[i_0__], 1);
            }
            current_statement_begin__ = 53;
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            tox = std::vector<int>(num_patients, int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_k_0_max__ = num_patients;
            for (size_t k_0__ = 0; k_0__ < tox_k_0_max__; ++k_0__) {
                tox[k_0__] = vals_i__[pos__++];
            }
            size_t tox_i_0_max__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "tox[i_0__]", tox[i_0__], 0);
                check_less_or_equal(function__, "tox[i_0__]", tox[i_0__], 1);
            }
            current_statement_begin__ = 54;
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            doses = std::vector<int>(num_patients, int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_k_0_max__ = num_patients;
            for (size_t k_0__ = 0; k_0__ < doses_k_0_max__; ++k_0__) {
                doses[k_0__] = vals_i__[pos__++];
            }
            size_t doses_i_0_max__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "doses[i_0__]", doses[i_0__], 1);
                check_less_or_equal(function__, "doses[i_0__]", doses[i_0__], num_doses);
            }
            // initialize transformed data variables
            current_statement_begin__ = 61;
            validate_non_negative_index("coded_doses", "num_doses", num_doses);
            coded_doses = std::vector<double>(num_doses, double(0));
            stan::math::fill(coded_doses, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("coded_doses_squ", "num_doses", num_doses);
            coded_doses_squ = std::vector<double>(num_doses, double(0));
            stan::math::fill(coded_doses_squ, DUMMY_VAR__);
            current_statement_begin__ = 63;
            mean_log_dose = double(0);
            stan::math::fill(mean_log_dose, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 64;
            stan::math::assign(mean_log_dose, 0.0);
            current_statement_begin__ = 65;
            for (int i = 1; i <= num_doses; ++i) {
                current_statement_begin__ = 66;
                stan::math::assign(mean_log_dose, (mean_log_dose + stan::math::log(get_base1(real_doses, i, "real_doses", 1))));
            }
            current_statement_begin__ = 67;
            stan::math::assign(mean_log_dose, (mean_log_dose / num_doses));
            current_statement_begin__ = 68;
            for (int i = 1; i <= num_doses; ++i) {
                current_statement_begin__ = 70;
                stan::model::assign(coded_doses, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::math::log(get_base1(real_doses, i, "real_doses", 1)) - mean_log_dose), 
                            "assigning variable coded_doses");
                current_statement_begin__ = 71;
                stan::model::assign(coded_doses_squ, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(get_base1(coded_doses, i, "coded_doses", 1), 2), 
                            "assigning variable coded_doses_squ");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 77;
            num_params_r__ += 1;
            current_statement_begin__ = 78;
            num_params_r__ += 1;
            current_statement_begin__ = 81;
            num_params_r__ += 1;
            current_statement_begin__ = 82;
            num_params_r__ += 1;
            current_statement_begin__ = 83;
            num_params_r__ += 1;
            current_statement_begin__ = 85;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_EffTox() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 77;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 78;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 81;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 82;
        if (!(context__.contains_r("zeta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable zeta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "zeta", "double", context__.to_vec());
        double zeta(0);
        zeta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(zeta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable zeta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 83;
        if (!(context__.contains_r("eta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "eta", "double", context__.to_vec());
        double eta(0);
        eta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(eta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 85;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 77;
            local_scalar_t__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();
            current_statement_begin__ = 78;
            local_scalar_t__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();
            current_statement_begin__ = 81;
            local_scalar_t__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();
            current_statement_begin__ = 82;
            local_scalar_t__ zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.scalar_constrain(lp__);
            else
                zeta = in__.scalar_constrain();
            current_statement_begin__ = 83;
            local_scalar_t__ eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.scalar_constrain(lp__);
            else
                eta = in__.scalar_constrain();
            current_statement_begin__ = 85;
            local_scalar_t__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_constrain(lp__);
            else
                psi = in__.scalar_constrain();
            // transformed parameters
            current_statement_begin__ = 89;
            validate_non_negative_index("prob_eff", "num_doses", num_doses);
            std::vector<local_scalar_t__> prob_eff(num_doses, local_scalar_t__(0));
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff, DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            std::vector<local_scalar_t__> prob_tox(num_doses, local_scalar_t__(0));
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("utility", "num_doses", num_doses);
            std::vector<local_scalar_t__> utility(num_doses, local_scalar_t__(0));
            stan::math::initialize(utility, DUMMY_VAR__);
            stan::math::fill(utility, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 94;
            for (int i = 1; i <= num_doses; ++i) {
                {
                current_statement_begin__ = 96;
                local_scalar_t__ r_to_the_p(DUMMY_VAR__);
                (void) r_to_the_p;  // dummy to suppress unused var warning
                stan::math::initialize(r_to_the_p, DUMMY_VAR__);
                stan::math::fill(r_to_the_p, DUMMY_VAR__);
                current_statement_begin__ = 97;
                stan::model::assign(prob_tox, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            inv_logit((alpha + (beta * get_base1(coded_doses, i, "coded_doses", 1)))), 
                            "assigning variable prob_tox");
                current_statement_begin__ = 98;
                stan::model::assign(prob_eff, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            inv_logit(((gamma + (zeta * get_base1(coded_doses, i, "coded_doses", 1))) + (eta * get_base1(coded_doses_squ, i, "coded_doses_squ", 1)))), 
                            "assigning variable prob_eff");
                current_statement_begin__ = 99;
                stan::math::assign(r_to_the_p, (pow(((1 - get_base1(prob_eff, i, "prob_eff", 1)) / (1 - eff0)), p) + pow((get_base1(prob_tox, i, "prob_tox", 1) / tox1), p)));
                current_statement_begin__ = 100;
                stan::model::assign(utility, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (1 - pow(r_to_the_p, (1.0 / p))), 
                            "assigning variable utility");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 89;
            size_t prob_eff_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(prob_eff[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_eff" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prob_eff: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t prob_eff_i_0_max__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < prob_eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 0);
                check_less_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 1);
            }
            current_statement_begin__ = 90;
            size_t prob_tox_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(prob_tox[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prob_tox: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t prob_tox_i_0_max__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < prob_tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 0);
                check_less_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 1);
            }
            current_statement_begin__ = 91;
            size_t utility_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < utility_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(utility[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: utility" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable utility: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 105;
            lp_accum__.add(normal_log(alpha, alpha_mean, alpha_sd));
            current_statement_begin__ = 106;
            lp_accum__.add(normal_log(beta, beta_mean, beta_sd));
            current_statement_begin__ = 107;
            lp_accum__.add(normal_log(gamma, gamma_mean, gamma_sd));
            current_statement_begin__ = 108;
            lp_accum__.add(normal_log(zeta, zeta_mean, zeta_sd));
            current_statement_begin__ = 109;
            lp_accum__.add(normal_log(eta, eta_mean, eta_sd));
            current_statement_begin__ = 110;
            lp_accum__.add(normal_log(psi, psi_mean, psi_sd));
            current_statement_begin__ = 111;
            lp_accum__.add(log_joint_pdf(coded_doses, coded_doses_squ, num_patients, eff, tox, doses, alpha, beta, gamma, zeta, eta, psi, pstream__));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("zeta");
        names__.push_back("eta");
        names__.push_back("psi");
        names__.push_back("prob_eff");
        names__.push_back("prob_tox");
        names__.push_back("utility");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_EffTox_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        vars__.push_back(alpha);
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);
        double gamma = in__.scalar_constrain();
        vars__.push_back(gamma);
        double zeta = in__.scalar_constrain();
        vars__.push_back(zeta);
        double eta = in__.scalar_constrain();
        vars__.push_back(eta);
        double psi = in__.scalar_constrain();
        vars__.push_back(psi);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 89;
            validate_non_negative_index("prob_eff", "num_doses", num_doses);
            std::vector<double> prob_eff(num_doses, double(0));
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff, DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            std::vector<double> prob_tox(num_doses, double(0));
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("utility", "num_doses", num_doses);
            std::vector<double> utility(num_doses, double(0));
            stan::math::initialize(utility, DUMMY_VAR__);
            stan::math::fill(utility, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 94;
            for (int i = 1; i <= num_doses; ++i) {
                {
                current_statement_begin__ = 96;
                local_scalar_t__ r_to_the_p(DUMMY_VAR__);
                (void) r_to_the_p;  // dummy to suppress unused var warning
                stan::math::initialize(r_to_the_p, DUMMY_VAR__);
                stan::math::fill(r_to_the_p, DUMMY_VAR__);
                current_statement_begin__ = 97;
                stan::model::assign(prob_tox, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            inv_logit((alpha + (beta * get_base1(coded_doses, i, "coded_doses", 1)))), 
                            "assigning variable prob_tox");
                current_statement_begin__ = 98;
                stan::model::assign(prob_eff, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            inv_logit(((gamma + (zeta * get_base1(coded_doses, i, "coded_doses", 1))) + (eta * get_base1(coded_doses_squ, i, "coded_doses_squ", 1)))), 
                            "assigning variable prob_eff");
                current_statement_begin__ = 99;
                stan::math::assign(r_to_the_p, (pow(((1 - get_base1(prob_eff, i, "prob_eff", 1)) / (1 - eff0)), p) + pow((get_base1(prob_tox, i, "prob_tox", 1) / tox1), p)));
                current_statement_begin__ = 100;
                stan::model::assign(utility, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (1 - pow(r_to_the_p, (1.0 / p))), 
                            "assigning variable utility");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 89;
            size_t prob_eff_i_0_max__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < prob_eff_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 0);
                check_less_or_equal(function__, "prob_eff[i_0__]", prob_eff[i_0__], 1);
            }
            current_statement_begin__ = 90;
            size_t prob_tox_i_0_max__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < prob_tox_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 0);
                check_less_or_equal(function__, "prob_tox[i_0__]", prob_tox[i_0__], 1);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t prob_eff_k_0_max__ = num_doses;
                for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                    vars__.push_back(prob_eff[k_0__]);
                }
                size_t prob_tox_k_0_max__ = num_doses;
                for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                    vars__.push_back(prob_tox[k_0__]);
                }
                size_t utility_k_0_max__ = num_doses;
                for (size_t k_0__ = 0; k_0__ < utility_k_0_max__; ++k_0__) {
                    vars__.push_back(utility[k_0__]);
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_EffTox";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t prob_eff_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_eff" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t prob_tox_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_tox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t utility_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < utility_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "utility" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t prob_eff_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_eff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_eff" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t prob_tox_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < prob_tox_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "prob_tox" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t utility_k_0_max__ = num_doses;
            for (size_t k_0__ = 0; k_0__ < utility_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "utility" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_EffTox_namespace::model_EffTox stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
