% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.eda.R
\name{roc.eda}
\alias{roc.eda}
\title{Exploratory data analysis for a three-class ROC marker}
\usage{
roc.eda(
  x,
  y,
  z,
  dat = NULL,
  type = c("empirical", "trinormal"),
  plotVUS = FALSE,
  saveVUS = FALSE,
  sep.dens = FALSE,
  scatter = FALSE,
  conf.level = 0.95,
  n.boot = 1000,
  verbose = TRUE,
  alternative = c("two.sided", "less", "greater"),
  class.labels = c("healthy", "intermediate", "diseased")
)
}
\arguments{
\item{x, y, z}{numeric vectors contaning the measurements from the healthy,
intermediate and diseased class.}

\item{dat}{a data frame of the following structure: The first column
represents a factor with three levels, containing the true class membership
of each measurement. The levels are ordered according to the convention of
higher values for more severe disease status.}

\item{type}{a character, specifying if the \code{empirical} VUS and tests or
the \code{trinormal} VUS and tests are computed.}

\item{plotVUS}{a logical whether to evaluate and plot the VUS (default is
\code{FALSE}). Note: To save a png \code{plotVUS} needs to be \code{TRUE} too.}

\item{saveVUS}{a logical whether to save a PNG of the VUS in your current
working directory (default is \code{FALSE}).}

\item{sep.dens}{a logical indicating if the density plots should be plotted
on separate x-axes (\code{TRUE}) or on a common axis (\code{FALSE}, is
default).}

\item{scatter}{a logical indicating if the measurements per class plot should
be plotted as a boxplot (default) or as a scatterplot (\code{scatter =
TRUE}).}

\item{conf.level}{A numeric value between 0 and 1 yielding the significance
level \eqn{\alpha=1-\code{conf.level}}.}

\item{n.boot}{an integer incicating the number of bootstrap replicates sampled
to obtain the variance of the VUS. Default is 1000.}

\item{verbose}{a logical, indicating whether output should be displayed or
not. Default is \code{TRUE}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}

\item{class.labels}{a vector of character strings of length 3 specifying the labels
of the three classes used for the axis labeling in the boxplot.}
}
\value{
A list with class "htest" containing the following components:
 \item{statistic}{The value of the test(s).}
 \item{p.value}{The p-value for the test(s).}
 \item{VUS}{the VUS computed with the specific method defined in
 \code{type}.}
 \item{dat.summary}{A data frame displaying size, mean and standard deviation
 of the three classes.}
 \item{alternative}{The alternative hypothesis.}
 \item{type}{a character containing the the method used for the exploratory
 data analysis.}
 \item{data.name}{a character containing the name of the data.}
 \item{xVUS, yVUS, zVUS}{(if \code{plotVUS = TRUE}) numeric vectors and
 matrices computed by \code{rocsurf.emp} or \code{rocsurf.trin}, used for
 displaying the surface with package \code{rgl}.}
 \item{histROC}{a \code{ggplot2} object, displaying the historgrams and
 densities of the three classes.}
 \item{meas.overview}{A ggplot2 object, displaying the boxplots (if
 \code{scatter = FALSE}) or scatter plots of the three classes (if
 \code{scatter = TRUE}).}
}
\description{
A function that investigates data that arose from a single marker and
contains the reference standard of the three classes "healthy",
"intermediate" and "diseased".
}
\details{
For the preliminary assessment of a classifier, exporatory
 data analysis  (EDA) on the markers is necessary. This function assesses
 measurements from a single marker and computes the VUS, statistical tests
 and returns a summary table as well as some plots of the data.
}
\section{Warning}{

If \code{type = "empirical"}, computation may take a while, as \code{roc.eda} calls
the function \code{boot.test()}.
}

\examples{
data(krebs)

# empirical EDA:
x <- with(krebs, krebs[trueClass=="healthy", 5])
y <- with(krebs, krebs[trueClass=="intermediate", 5])
z <- with(krebs, krebs[trueClass=="diseased", 5])
roc.eda(x, y, z, type = "e", plotVUS = FALSE)

# equal data input via:
# roc.eda(dat = krebs[,c(1,5)], type = "e", plotVUS = FALSE)

data(cancer)
# trinormal EDA:
roc.eda(dat = cancer[,c(1,10)], type = "trin", plotVUS = FALSE)
# trinormal EDA with different plots:
roc.eda(dat = cancer[,c(1,5)], type = "t", sep.dens = TRUE, scatter = TRUE)
}
\seealso{
\code{\link{trinROC.test}}, \code{\link{trinVUS.test}} for trinormal
  data investigation, \code{\link{boot.test}} for empirical data analysis.
  \code{\link{rocsurf.emp}}, \code{\link{rocsurf.trin}} for the surface plot.
}
