% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncAIPW.R
\name{truncAIPW}
\alias{truncAIPW}
\title{Doubly Robust Estimation under Covariate-induced Dependent Left Truncation and No Censoring}
\usage{
truncAIPW(dat, nu, Fuz.mx, Gvz.mx, T.name, Q.name, trim = 1e-07)
}
\arguments{
\item{dat}{data frame that contains the data for constructing the estimating equation.}

\item{nu}{transformation that defines the parameter of interest.}

\item{Fuz.mx}{matrix for the estimated conditional CDF of the event time given covariates. Each row corresponds to a subject, and each column corresponds to a time point. The column names of the matrix are the time points. See \code{\link{F_est}} for an example of computing this conditional CDF matrix.}

\item{Gvz.mx}{matrix for the estimated conditional CDF of the truncation time given covariates. Each row corresponds to a subject, and each column corresponds to a time point. The column names of the matrix are the time points. See \code{\link{G_est}} for an example of computing this conditional CDF matrix.}

\item{T.name}{name of the event time variable.}

\item{Q.name}{name of the left truncation time variable.}

\item{trim}{constant that is used to bound from below for the denominators involved in the computation.}
}
\value{
\code{truncAIPW()} returns a list of estimators (`dr', `IPW.Q', `Reg.T1', `Reg.T2'), and the model-based standard errors for the `dr' and `IPW.Q' estimators.
\item{dr}{doubly robust estimator `dr'.}
\item{IPW.Q}{inverse probability of truncation weighted estimator `IPW.Q'.}
\item{Reg.T1}{regression based estimator `Reg.T1'.}
\item{Reg.T2}{regression based estimator `Reg.T2'.}
\item{SE_dr}{standard error of the `dr' estimator based on the efficient influence function.}
\item{SE_IPW.Q}{standard error of the `IPW.Q' estimator computed from the robust sandwich variance estimator assuming the truncation weights are known.}
}
\description{
Doubly robust estimation for the mean of an arbitrarily transformed survival time under covariate-induced dependent left truncation and no right censoring.
}
\examples{
data("simu")
nu <- function(t){ return(as.numeric(t>3)) }
u = c(min(simu$time)-1e-10, sort(simu$time), max(simu$time)+1e-10)
v = c(min(simu$Q)-1e-10, sort(simu$Q), max(simu$Q)+1e-10)
Fuz.mx = F_est(simu, simu, u, "Cox", "time", "Q", "delta", c("Z1","Z2"))
Gvz.mx = G_est(simu, simu, v, "Cox", "time", "Q", "delta", c("Z1","Z2"))

est = truncAIPW(simu, nu, Fuz.mx, Gvz.mx, "time", "Q", trim = 1e-7)
est
}
\references{
Wang, Y., Ying, A., Xu, R. (2022) "Doubly robust estimation under covariate-induced dependent left truncation" <arXiv:2208.06836>.
}
\seealso{
See \code{\link{truncAIPW_cen1}}, \code{\link{truncAIPW_cen2}} for the estimations also under noninformative right censoring. See \code{\link{F_est}}, \code{\link{G_est}} for examples of computing the input matrices for the conditional CDF's.
}
