% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out-of-bag-pipes.r
\name{intraining_estimations}
\alias{intraining_estimations}
\title{Out-of-bag loss estimations}
\usage{
intraining_estimations(train, test, form, specs, lfun, num_cores)
}
\arguments{
\item{train}{train set from the training set;}

\item{test}{test set from the training set;}

\item{form}{formula;}

\item{specs}{object of class \code{\link{model_specs-class}}. Contains
the specifications of the base models.}

\item{lfun}{loss function for metalearning. Defaults to ae -- absolute error.}

\item{num_cores}{A numeric value to specify the number of cores used to
train base and meta models. num_cores = 1
leads to sequential training of models. num_cores > 1
splits the training of the base models across num_cores cores.}
}
\value{
A list containing two objects:
\describe{
\item{mloss}{loss of base models in \strong{test}}
\item{oob}{out-of-bag test samples}
\item{Y_hat}{predictions by base models}
}
}
\description{
A pipeline for retrieving out-of-bag loss estimations
}
\seealso{
Other out-of-bag functions: 
\code{\link{intraining_predictions}()}
}
\concept{out-of-bag functions}
\keyword{internal}
