% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.TARMA.R
\name{predict.TARMA}
\alias{predict.TARMA}
\title{Forecast from fitted TARMA models.}
\usage{
\method{predict}{TARMA}(
  object,
  x,
  n.ahead = 0,
  n.sim = 1000,
  quant = c(0.05, 0.95),
  pred.matrix = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{TARMA} fit upon x.}

\item{x}{The fitted time series.}

\item{n.ahead}{The number of steps ahead for which prediction is required.}

\item{n.sim}{The number of Monte Carlo replications used to simulate the prediction density.}

\item{quant}{Vector of quantiles (in the interval \code{[0, 1]}) to be computed upon the prediction density.}

\item{pred.matrix}{Logical. if \code{TRUE} prints also the whole simulated prediction density for each prediction horizon from \code{1} to \code{n.ahead}.}

\item{\dots}{Additional arguments.}
}
\value{
A list with components \code{pred.matrix}, \code{pred}, and \code{pred.interval}. The latter two are \code{ts} objects that contain the prediction and the quantiles of the prediction density, respectively.
If \code{pred.matrix = TRUE} then the prediction density from which the quantiles are computed is also returned.
}
\description{
Forecasting with TARMA models
}
\details{
If \code{n.ahead = 0} it gives the fitted values from the model.
If the fit is from \code{TARMA.fit2} and includes covariates, these are ignored.
}
\examples{
## a TARMA(1,1,1,1) model
set.seed(13)
x1   <- TARMA.sim(n=200, phi1=c(0.5,-0.5), phi2=c(0.0,0.5), theta1=-0.5, theta2=0.7, d=1, thd=0.2)
fit1 <- TARMA.fit(x1, method='L-BFGS-B',tar1.lags = 1, tar2.lags = 1, tma1.lags = 1, 
        tma2.lags = 1, d=1, threshold=0.2)
xp1  <- predict(fit1,x1,n.ahead=2)
xp1
}
\references{
\itemize{
\item \insertRef{Gia21}{tseriesTARMA}
}
}
\seealso{
\code{\link{TARMA.fit}} and \code{\link{TARMA.fit2}} for TARMA modelling. \code{\link{plot.tsfit}} for plotting TARMA fits and forecasts.
}
\author{
Simone Giannerini, \email{simone.giannerini@uniud.it}

Greta Goracci, \email{greta.goracci@unibz.it}
}
