% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.3.0.R
\name{tsdiff}
\alias{tsdiff}
\title{Difference a Time Series}
\usage{
tsdiff(x, lag = 1L, order = 1L, lag.D = 0L, order.D = 0L)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{lag}{number of lags for non-seasonal differencing. Default is \code{1}.}

\item{order}{order of non-seasonal differencing. Default is \code{1}.}

\item{lag.D}{number of lags for seasonal differencing. Default is \code{0}.}

\item{order.D}{order of seasonal differencing. Default is \code{0}.}
}
\value{
The differences of \code{x} will be returned with all the attributes being carried over. Unlike the function \code{\link{diff}}, the output series by \code{tsdiff} has the same length as the original series by adding \code{NA} to those observations at the beginning of the series for which no differencing can be carried out.
}
\description{
The function `\code{tsdiff}` generates the differenced series of a non-stationary time series.
}
\details{
The parameters \code{lag} and \code{lag.D} are only necessary if the lag difference for differencing is not 1 or \eqn{\ell}, the seasonal cycle length, respectively. If \code{order.D > 0} but \code{lag.D} is omitted, R will use the frequency of the series for this parameter.
}
\examples{
travellers_d <- tsdiff(x = airport$Travellers, order = 1, order.D = 1)
tsexplore(travellers_d, lag.max = 60)
}
\seealso{
\link{diff}
}
\author{
Ka Yui Karl Wu
}
