% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmctsir_function.R
\name{mcmctsir}
\alias{mcmctsir}
\title{mcmctsir}
\usage{
mcmctsir(
  data,
  xreg = "cumcases",
  IP = 2,
  nsim = 100,
  regtype = "gaussian",
  sigmamax = 3,
  userYhat = numeric(),
  update.iter = 10000,
  n.iter = 30000,
  n.chains = 3,
  n.adapt = 1000,
  burn.in = 100,
  method = "deterministic",
  epidemics = "cont",
  pred = "forward",
  seasonality = "standard",
  inits.fit = FALSE,
  threshold = 1,
  sbar = NULL,
  alpha = NULL,
  add.noise.sd = 0,
  mul.noise.sd = 0,
  printon = F
)
}
\arguments{
\item{data}{The data frame containing cases and interpolated births and populations.}

\item{xreg}{The x-axis for the regression. Options are 'cumcases' and 'cumbirths'. Defaults to 'cumcases'.}

\item{IP}{The infectious period in weeks. Defaults to 2 weeks.}

\item{nsim}{The number of simulations to do. Defaults to 100.}

\item{regtype}{The type of regression used in susceptible reconstruction.
Options are 'gaussian', 'lm' (linear model), 'spline' (smooth.spline with 2.5 degrees freedom),
'lowess' (with f = 2/3, iter = 1), 'loess' (degree 1), and 'user' which is just a user inputed vector.
Defaults to 'gaussian' and if that fails then defaults to loess.}

\item{sigmamax}{The inverse kernal width for the gaussian regression. Default is 3.
Smaller, stochastic outbreaks tend to need a lower sigma.}

\item{userYhat}{The inputed regression vector if regtype='user'. Defaults to NULL.}

\item{update.iter}{Number of MCMC iterations to use in the update aspect. Default is 10000.}

\item{n.iter}{Number of MCMC iterations to use. Default is 30000.}

\item{n.chains}{Number of MCMC chains to use. Default is 3.}

\item{n.adapt}{Adaptive number for MCMC. Default is 1000.}

\item{burn.in}{Burn in number. Default is 100.}

\item{method}{The type of next step prediction used. Options are 'negbin' for negative binomial,
'pois' for poisson distribution, and 'deterministic'. Defaults to 'deterministic'.}

\item{epidemics}{The type of data splitting. Options are 'cont' which doesn't split the data up at all,
and 'break' which breaks the epidemics up if there are a lot of zeros. Defaults to 'cont'.}

\item{pred}{The type of prediction used. Options are 'forward' and 'step-ahead'. Defaults to 'forward'.}

\item{seasonality}{The type of contact to use. Options are standard for 52/IP point contact or schoolterm for just a two point on off contact or none for a single contact parameter. Defaults to standard.}

\item{inits.fit}{Whether or not to fit initial conditions using simple least squares as well. Defaults to FALSE. This parameter is more necessary in more chaotic locations.}

\item{threshold}{The cut off for a new epidemic if epidemics = 'break'. Defaults to 1.}

\item{sbar}{The mean number of susceptibles. Defaults to NULL, i.e. the function estimates sbar.}

\item{alpha}{The mixing parameter. Defaults to NULL, i.e. the function estimates alpha.}

\item{add.noise.sd}{The sd for additive noise, defaults to zero.}

\item{mul.noise.sd}{The sd for multiplicative noise, defaults to zero.}

\item{printon}{Whether to show diagnostic prints or not, defaults to FALSE.}
}
\description{
This function runs the TSIR model using a MCMC estimation. The susceptibles are still reconstructed in the same way as the regular tsir model, however beta, alpha, and sbar (or whatever combination you enter) are estimated using rjargs.
}
