% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fit_data}
\alias{fit_data}
\title{Example Posterior Samples}
\format{
## `fit_data`
A list with two elements, each containing posterior samples for one individual.
}
\source{
The data is generated using the \code{\link{stan_gvar}} function on subsets
of the \code{\link{ts_data}} time series data.
}
\usage{
data(fit_data)
}
\description{
This dataset contains posterior samples of beta coefficients and partial correlations for two individuals.
It was generated by fitting a GVAR model using \code{\link{stan_gvar}} with three variables from the \code{\link{ts_data}} dataset.
}
\details{
The list contains two elements, each containing posterior samples for one individual.
The samples were extracted using the \code{\link{stan_fit_convert}} function.
For each individual, the list elements contain the posterior means of the beta coefficients
("beta_mu") and the posterior means of the partial correlations ("pcor_mu").
The "fit" element contains all 1000 posterior samples of the beta coefficients and partial correlations.
}
\keyword{dataset}
