% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wins.R
\name{wins}
\alias{wins}
\alias{colWins}
\alias{rowWins}
\title{Winsorise}
\usage{
wins(x, p = 0.05)

colWins(x, p = 0.05)

rowWins(x, p = 0.05)
}
\arguments{
\item{x}{input data. NAs will be removed.}

\item{p}{percentage or number of observations to be winsorised. If value is <1 then it is used as a percentages. Otherwise it is the number of observations to winsorise. If the resulting p > floor((length(x)-1)/2), then it is set equal to floor((length(x)-1)/2).}
}
\value{
Winsorised vector.
}
\description{
Winsorise either by number or percentage of observations.
}
\section{Functions}{
\itemize{
\item \code{colWins()}: Vectorised version of wins by columns.

\item \code{rowWins()}: Vectorised version of wins by rows.

}}
\examples{
x <- rnorm(100,mean=0,sd=1)
xW <- wins(x)

}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{colWins}
\keyword{rowWins}
\keyword{wins}
