% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoCoprimary2BinaryApprox.R
\name{twoCoprimary2BinaryApprox}
\alias{twoCoprimary2BinaryApprox}
\title{Unified Interface for Two Co-Primary Binary Endpoints (Approximate Methods)}
\usage{
twoCoprimary2BinaryApprox(
  n1 = NULL,
  n2 = NULL,
  p11,
  p12,
  p21,
  p22,
  rho1,
  rho2,
  power = NULL,
  r = NULL,
  alpha = 0.025,
  Test = "AN"
)
}
\arguments{
\item{n1}{Sample size for group 1 (treatment group). If NULL, will be calculated.}

\item{n2}{Sample size for group 2 (control group). If NULL, will be calculated.}

\item{p11}{True response probability for endpoint 1 in group 1}

\item{p12}{True response probability for endpoint 2 in group 1}

\item{p21}{True response probability for endpoint 1 in group 2}

\item{p22}{True response probability for endpoint 2 in group 2}

\item{rho1}{Correlation between endpoints 1 and 2 in group 1}

\item{rho2}{Correlation between endpoints 1 and 2 in group 2}

\item{power}{Target power (1 - beta). If NULL, will be calculated.}

\item{r}{Allocation ratio (n1/n2). Required when calculating sample size.}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{Test}{Test method: "AN" (asymptotic normal), "ANc" (with continuity
correction), "AS" (arcsine), or "ASc" (arcsine with continuity correction)}
}
\value{
An object of class "twoCoprimary" containing either:
\itemize{
\item Power calculation results (when n1 and n2 are specified)
\item Sample size calculation results (when power and r are specified)
}
}
\description{
This function provides a unified interface for both power calculation and
sample size determination for two co-primary binary endpoints using
asymptotic normal approximation methods.
}
\details{
This function serves as a unified interface similar to \code{power.prop.test()}.
The function determines the operation mode based on which parameters are NULL.

Exactly one of \{(n1, n2), (power, r)\} must be NULL.
}
\examples{
# Calculate power given sample sizes
twoCoprimary2BinaryApprox(
  n1 = 200, n2 = 100,
  p11 = 0.5, p12 = 0.4,
  p21 = 0.3, p22 = 0.2,
  rho1 = 0.7, rho2 = 0.7,
  alpha = 0.025, Test = "AN"
)

# Calculate sample size given target power
twoCoprimary2BinaryApprox(
  p11 = 0.5, p12 = 0.4,
  p21 = 0.3, p22 = 0.2,
  rho1 = 0.7, rho2 = 0.7,
  power = 0.8, r = 1,
  alpha = 0.025, Test = "AN"
)

}
