% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimatePi.R
\name{estimatePi}
\alias{estimatePi}
\title{estimatePi}
\usage{
estimatePi(
  Y,
  A,
  W,
  condSetNames,
  W.Q,
  Delta.W,
  V.msm = NULL,
  piform,
  pi.SL.library,
  id,
  V,
  discreteSL,
  verbose,
  pi = NULL,
  obsWeights = rep(1, nrow(W))
)
}
\arguments{
\item{Y}{outcome}

\item{A}{binary treatment indicator}

\item{W}{covariate matrix observed on everyone}

\item{condSetNames}{Variables to include as predictors of missingness
in \code{W.stage2}, any combination of \code{Y, A}, and either \code{W}
(for all covariates in \code{W}) or individual covariate names in \code{W}}

\item{W.Q}{additional covariates based on preliminary outcome regression}

\item{Delta.W}{binary indicator of missing second stage covariates}

\item{V.msm}{optional additional covariates to condition on beyond \code{W}}

\item{piform}{parametric regression formula for estimating \code{pi}}

\item{pi.SL.library}{super learner library for estimating \code{pi}}

\item{id}{Identifier of independent units of observation, e.g., clusters}

\item{V}{number of cross validation folds for estimating \code{pi}
using super learner}

\item{discreteSL}{Use discrete super learning when \code{TRUE}, otherwise
ensemble super learning}

\item{verbose}{When \code{TRUE} prints informational messages}

\item{pi}{optional vector of user-specified probabilities}

\item{obsWeights}{optional weights for evaluating pi}
}
\value{
list containing the predicted probabilities, estimation method
coefficients in parametric regression model (if piform supplied),
indicator of whether discrete or ensemble SL was used.
}
\description{
Typically not called directly by the user. Function for modeling
the two-stage missingness mechanism and evaluating conditional
probabilities for each observation
}
